/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Hashtable;
import org.hsqldb.util.JDBCTypes;
import org.hsqldb.util.Traceable;
import org.hsqldb.util.TransferDb;
import org.hsqldb.util.TransferTable;

class TransferHelper {
    protected TransferDb db;
    protected Traceable tracer;
    protected String sSchema;
    protected JDBCTypes JDBCT;
    private String quote;

    TransferHelper() {
        this.db = null;
        this.tracer = null;
        this.quote = "'";
        this.JDBCT = new JDBCTypes();
    }

    TransferHelper(TransferDb transferDb, Traceable traceable, String string) {
        this.db = transferDb;
        this.tracer = traceable;
        this.quote = string;
        this.JDBCT = new JDBCTypes();
    }

    void set(TransferDb transferDb, Traceable traceable, String string) {
        this.db = transferDb;
        this.tracer = traceable;
        this.quote = string;
    }

    String formatIdentifier(String string) {
        if (string == null) {
            return string;
        }
        if (string.equals("")) {
            return string;
        }
        if (!Character.isLetter(string.charAt(0)) || string.indexOf(32) != -1) {
            return this.quote + string + this.quote;
        }
        return string;
    }

    void setSchema(String string) {
        this.sSchema = string;
    }

    String formatName(String string) {
        String string2 = "";
        if (this.sSchema != null && this.sSchema.length() > 0) {
            string2 = this.sSchema + ".";
        }
        string2 = string2 + this.formatIdentifier(string);
        return string2;
    }

    int convertFromType(int n) {
        return n;
    }

    int convertToType(int n) {
        return n;
    }

    Hashtable getSupportedTypes() {
        Hashtable hashtable = new Hashtable();
        if (this.db != null) {
            try {
                ResultSet resultSet = this.db.meta.getTypeInfo();
                while (resultSet.next()) {
                    Integer n = new Integer(resultSet.getShort(2));
                    if (hashtable.get(n) != null) continue;
                    try {
                        hashtable.put(n, this.JDBCT.toString(resultSet.getShort(2)));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                resultSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (hashtable.isEmpty()) {
            hashtable = this.JDBCT.getHashtable();
        }
        return hashtable;
    }

    String fixupColumnDefRead(TransferTable transferTable, ResultSetMetaData resultSetMetaData, String string, ResultSet resultSet, int n) throws SQLException {
        return string;
    }

    String fixupColumnDefWrite(TransferTable transferTable, ResultSetMetaData resultSetMetaData, String string, ResultSet resultSet, int n) throws SQLException {
        return string;
    }

    boolean needTransferTransaction() {
        return false;
    }

    Object convertColumnValue(Object object, int n, int n2) {
        return object;
    }

    void beginDataTransfer() {
    }

    void endDataTransfer() {
    }

    String fixupColumnDefRead(String string, ResultSetMetaData resultSetMetaData, String string2, ResultSet resultSet, int n) throws SQLException {
        return string2;
    }

    String fixupColumnDefWrite(String string, ResultSetMetaData resultSetMetaData, String string2, ResultSet resultSet, int n) throws SQLException {
        return string2;
    }
}

