/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.sql.SQLException;
import org.xml.sax.SAXException;

public class JDOMException
extends Exception {
    private static final String CVS_ID = "@(#) $RCSfile: JDOMException.java,v $ $Revision: 1.18 $ $Date: 2003/04/06 02:00:44 $ $Name: jdom_1_0_b9_rc1 $";
    protected Throwable cause;

    public JDOMException() {
        super("Error occurred in JDOM application.");
    }

    public JDOMException(String message) {
        super(message);
    }

    public JDOMException(String message, Throwable cause) {
        super(message);
        this.cause = cause;
    }

    public Throwable initCause(Throwable cause) {
        this.cause = cause;
        return cause;
    }

    /*
     * WARNING - void declaration
     */
    public String getMessage() {
        Throwable child;
        String msg = super.getMessage();
        JDOMException parent = this;
        while ((child = JDOMException.getNestedException(parent)) != null) {
            Exception grandchild;
            void var3_3;
            String msg2 = var3_3.getMessage();
            if (var3_3 instanceof SAXException && (grandchild = ((SAXException)var3_3).getException()) != null && msg2 != null && msg2.equals(grandchild.getMessage())) {
                msg2 = null;
            }
            if (msg2 != null) {
                msg = msg != null ? msg + ": " + msg2 : msg2;
            }
            if (var3_3 instanceof JDOMException) break;
            parent = var3_3;
        }
        return msg;
    }

    /*
     * WARNING - void declaration
     */
    public void printStackTrace() {
        Throwable child;
        super.printStackTrace();
        JDOMException parent = this;
        while ((child = JDOMException.getNestedException(parent)) != null) {
            void var2_2;
            if (var2_2 == null) continue;
            System.err.print("Caused by: ");
            var2_2.printStackTrace();
            if (var2_2 instanceof JDOMException) break;
            parent = var2_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void printStackTrace(PrintStream s) {
        Throwable child;
        super.printStackTrace(s);
        JDOMException parent = this;
        while ((child = JDOMException.getNestedException(parent)) != null) {
            void var3_3;
            if (var3_3 == null) continue;
            s.print("Caused by: ");
            var3_3.printStackTrace(s);
            if (var3_3 instanceof JDOMException) break;
            parent = var3_3;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void printStackTrace(PrintWriter w) {
        Throwable child;
        super.printStackTrace(w);
        JDOMException parent = this;
        while ((child = JDOMException.getNestedException(parent)) != null) {
            void var3_3;
            if (var3_3 == null) continue;
            w.print("Caused by: ");
            var3_3.printStackTrace(w);
            if (var3_3 instanceof JDOMException) break;
            parent = var3_3;
        }
    }

    public Throwable getCause() {
        return this.cause;
    }

    private static Throwable getNestedException(Throwable parent) {
        if (parent instanceof JDOMException) {
            return ((JDOMException)parent).getCause();
        }
        if (parent instanceof SAXException) {
            return ((SAXException)parent).getException();
        }
        if (parent instanceof SQLException) {
            return ((SQLException)parent).getNextException();
        }
        if (parent instanceof InvocationTargetException) {
            return ((InvocationTargetException)parent).getTargetException();
        }
        if (parent instanceof ExceptionInInitializerError) {
            return ((ExceptionInInitializerError)parent).getException();
        }
        if (parent instanceof RemoteException) {
            return ((RemoteException)parent).detail;
        }
        Throwable nestedException = JDOMException.getNestedException(parent, "javax.naming.NamingException", "getRootCause");
        if (nestedException != null) {
            return nestedException;
        }
        nestedException = JDOMException.getNestedException(parent, "javax.servlet.ServletException", "getRootCause");
        if (nestedException != null) {
            return nestedException;
        }
        return null;
    }

    private static Throwable getNestedException(Throwable parent, String className, String methodName) {
        try {
            Class<?> testClass = Class.forName(className);
            Class<?> objectClass = parent.getClass();
            if (testClass.isAssignableFrom(objectClass)) {
                Class[] argClasses = new Class[]{};
                Method method = testClass.getMethod(methodName, argClasses);
                Object[] args = new Object[]{};
                return (Throwable)method.invoke((Object)parent, args);
            }
        }
        catch (Exception ex) {}
        return null;
    }
}

