/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import java.io.Serializable;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.IllegalDataException;
import org.jdom.Verifier;

public class Text
implements Serializable,
Cloneable {
    private static final String CVS_ID = "@(#) $RCSfile: Text.java,v $ $Revision: 1.15 $ $Date: 2002/05/17 15:46:07 $ $Name: jdom_1_0_b9_rc1 $";
    private static final String EMPTY_STRING = "";
    protected String value;
    protected Object parent;

    protected Text() {
    }

    public Text(String str) {
        this.setText(str);
    }

    public String getText() {
        return this.value;
    }

    public String getTextTrim() {
        return this.getText().trim();
    }

    public String getTextNormalize() {
        return Text.normalizeString(this.getText());
    }

    public static String normalizeString(String str) {
        if (str == null) {
            return EMPTY_STRING;
        }
        char[] c = str.toCharArray();
        char[] n = new char[c.length];
        boolean white = true;
        int pos = 0;
        int i = 0;
        while (i < c.length) {
            if (" \t\n\r".indexOf(c[i]) != -1) {
                if (!white) {
                    n[pos++] = 32;
                    white = true;
                }
            } else {
                n[pos++] = c[i];
                white = false;
            }
            ++i;
        }
        if (white && pos > 0) {
            --pos;
        }
        return new String(n, 0, pos);
    }

    public Text setText(String str) {
        if (str == null) {
            this.value = EMPTY_STRING;
            return this;
        }
        String reason = Verifier.checkCharacterData(str);
        if (reason != null) {
            throw new IllegalDataException(str, "character content", reason);
        }
        this.value = str;
        return this;
    }

    public void append(String str) {
        if (str == null) {
            return;
        }
        String reason = Verifier.checkCharacterData(str);
        if (reason != null) {
            throw new IllegalDataException(str, "character content", reason);
        }
        this.value = str == EMPTY_STRING ? str : this.value + str;
    }

    public void append(Text text) {
        if (text == null) {
            return;
        }
        this.value = this.value + text.getText();
    }

    public Element getParent() {
        return (Element)this.parent;
    }

    public Document getDocument() {
        if (this.parent != null) {
            return ((Element)this.parent).getDocument();
        }
        return null;
    }

    protected Text setParent(Element parent) {
        this.parent = parent;
        return this;
    }

    public Text detach() {
        if (this.parent != null) {
            ((Element)this.parent).removeContent(this);
        }
        this.parent = null;
        return this;
    }

    public String toString() {
        return new StringBuffer(64).append("[Text: ").append(this.getText()).append("]").toString();
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public Object clone() {
        Text text = null;
        try {
            text = (Text)super.clone();
        }
        catch (CloneNotSupportedException ce) {
            // empty catch block
        }
        text.parent = null;
        text.value = this.value;
        return text;
    }

    public final boolean equals(Object ob) {
        return this == ob;
    }
}

