/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.datastore.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datastore.jdbc.BusinessEntityTable;
import org.apache.juddi.datastore.jdbc.ContactTable;
import org.apache.juddi.datatype.Address;
import org.apache.juddi.datatype.business.BusinessEntity;
import org.apache.juddi.datatype.business.Contact;
import org.apache.juddi.util.Config;
import org.apache.juddi.util.jdbc.ConnectionManager;
import org.apache.juddi.util.jdbc.Transaction;
import org.apache.juddi.uuidgen.UUIDGen;
import org.apache.juddi.uuidgen.UUIDGenFactory;

class AddressTable {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$juddi$datastore$jdbc$AddressTable == null ? (class$org$apache$juddi$datastore$jdbc$AddressTable = AddressTable.class$("org.apache.juddi.datastore.jdbc.AddressTable")) : class$org$apache$juddi$datastore$jdbc$AddressTable));
    static String insertSQL = null;
    static String selectSQL = null;
    static String deleteSQL = null;
    static /* synthetic */ Class class$org$apache$juddi$datastore$jdbc$AddressTable;

    AddressTable() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insert(String businessKey, int contactID, Vector addrList, Connection connection) throws SQLException {
        if (addrList == null || addrList.size() == 0) {
            return;
        }
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(insertSQL);
            statement.setString(1, businessKey.toString());
            statement.setInt(2, contactID);
            int listSize = addrList.size();
            for (int addressID = 0; addressID < listSize; ++addressID) {
                Address address = (Address)addrList.elementAt(addressID);
                statement.setInt(3, addressID);
                statement.setString(4, address.getUseType());
                statement.setString(5, address.getSortCode());
                statement.setString(6, address.getTModelKey());
                log.debug((Object)("insert into ADDRESS table:\n\n\t" + insertSQL + "\n\t BUSINESS_KEY=" + businessKey.toString() + "\n\t CONTACT_ID=" + contactID + "\n\t ADDRESS_ID=" + addressID + "\n\t USE_TYPE=" + address.getUseType() + "\n\t SORT_CODE=" + address.getSortCode() + "\n\t TMODEL_KEY=" + address.getTModelKey() + "\n"));
                statement.executeUpdate();
            }
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector select(String businessKey, int contactID, Connection connection) throws SQLException {
        Vector<Address> addrList = new Vector<Address>();
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.prepareStatement(selectSQL);
            statement.setString(1, businessKey.toString());
            statement.setInt(2, contactID);
            log.debug((Object)("select from ADDRESS table:\n\n\t" + selectSQL + "\n\t BUSINESS_KEY=" + businessKey.toString() + "\n\t CONTACT_ID=" + contactID + "\n"));
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                Address address = new Address();
                address.setUseType(resultSet.getString(1));
                address.setSortCode(resultSet.getString(2));
                address.setTModelKey(resultSet.getString(3));
                addrList.add(address);
                address = null;
            }
            Vector<Address> vector = addrList;
            return vector;
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delete(String businessKey, Connection connection) throws SQLException {
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(deleteSQL);
            statement.setString(1, businessKey.toString());
            log.debug((Object)("delete from ADDRESS table:\n\n\t" + deleteSQL + "\n\t BUSINESS_KEY=" + businessKey.toString() + "\n"));
            statement.executeUpdate();
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Config.setStringProperty("juddi.useConnectionPool", "true");
        Connection conn = null;
        try {
            conn = ConnectionManager.aquireConnection();
            AddressTable.test(conn);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    public static void test(Connection connection) throws Exception {
        Transaction txn = new Transaction();
        UUIDGen uuidgen = UUIDGenFactory.getUUIDGen();
        if (connection != null) {
            try {
                String authorizedUserID = "sviens";
                String businessKey = uuidgen.uuidgen();
                BusinessEntity business = new BusinessEntity();
                business.setBusinessKey(businessKey);
                business.setAuthorizedName("sviens");
                business.setOperator("WebServiceRegistry.com");
                Vector<Contact> contactList = new Vector<Contact>();
                Contact contact = new Contact("Bill Bob");
                contact.setUseType("server");
                contactList.add(contact);
                int contactID = 0;
                Vector addrList = new Vector();
                Address address = null;
                address = new Address();
                address.setUseType("Mailing");
                address.setSortCode("a");
                addrList.add(address);
                address = new Address();
                address.setUseType("Shipping");
                address.setSortCode("b");
                addrList.add(address);
                address = new Address();
                address.setUseType("Marketing");
                address.setSortCode("c");
                addrList.add(address);
                address = new Address();
                address.setUseType("Sales");
                address.setSortCode("d");
                addrList.add(address);
                address = new Address();
                address.setUseType("Engineering");
                address.setSortCode("e");
                addrList.add(address);
                txn.begin(connection);
                BusinessEntityTable.insert(business, authorizedUserID, connection);
                ContactTable.insert(businessKey, contactList, connection);
                AddressTable.insert(businessKey, contactID, addrList, connection);
                addrList = AddressTable.select(businessKey, contactID, connection);
                AddressTable.delete(businessKey, connection);
                addrList = AddressTable.select(businessKey, contactID, connection);
                txn.commit();
            }
            catch (Exception ex) {
                try {
                    txn.rollback();
                }
                catch (SQLException sqlex) {
                    sqlex.printStackTrace();
                }
                throw ex;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        StringBuffer sql = null;
        sql = new StringBuffer(150);
        sql.append("INSERT INTO ADDRESS (");
        sql.append("BUSINESS_KEY,");
        sql.append("CONTACT_ID,");
        sql.append("ADDRESS_ID,");
        sql.append("USE_TYPE,");
        sql.append("SORT_CODE,");
        sql.append("TMODEL_KEY) ");
        sql.append("VALUES (?,?,?,?,?,?)");
        insertSQL = sql.toString();
        sql = new StringBuffer(200);
        sql.append("SELECT ");
        sql.append("USE_TYPE,");
        sql.append("SORT_CODE,");
        sql.append("TMODEL_KEY, ");
        sql.append("ADDRESS_ID ");
        sql.append("FROM ADDRESS ");
        sql.append("WHERE BUSINESS_KEY=? ");
        sql.append("AND CONTACT_ID=? ");
        sql.append("ORDER BY ADDRESS_ID");
        selectSQL = sql.toString();
        sql = new StringBuffer(100);
        sql.append("DELETE FROM ADDRESS ");
        sql.append("WHERE BUSINESS_KEY=?");
        deleteSQL = sql.toString();
    }
}

