/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.datastore.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datastore.jdbc.BindingTemplateTable;
import org.apache.juddi.datastore.jdbc.BusinessEntityTable;
import org.apache.juddi.datastore.jdbc.BusinessServiceTable;
import org.apache.juddi.datatype.KeyedReference;
import org.apache.juddi.datatype.binding.AccessPoint;
import org.apache.juddi.datatype.binding.BindingTemplate;
import org.apache.juddi.datatype.business.BusinessEntity;
import org.apache.juddi.datatype.service.BusinessService;
import org.apache.juddi.util.Config;
import org.apache.juddi.util.jdbc.ConnectionManager;
import org.apache.juddi.util.jdbc.Transaction;
import org.apache.juddi.uuidgen.UUIDGen;
import org.apache.juddi.uuidgen.UUIDGenFactory;

class BindingCategoryTable {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$juddi$datastore$jdbc$BindingCategoryTable == null ? (class$org$apache$juddi$datastore$jdbc$BindingCategoryTable = BindingCategoryTable.class$("org.apache.juddi.datastore.jdbc.BindingCategoryTable")) : class$org$apache$juddi$datastore$jdbc$BindingCategoryTable));
    static String insertSQL = null;
    static String selectSQL = null;
    static String deleteSQL = null;
    static /* synthetic */ Class class$org$apache$juddi$datastore$jdbc$BindingCategoryTable;

    BindingCategoryTable() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insert(String bindingKey, Vector keyRefs, Connection connection) throws SQLException {
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(insertSQL);
            statement.setString(1, bindingKey.toString());
            int listSize = keyRefs.size();
            for (int categoryID = 0; categoryID < listSize; ++categoryID) {
                KeyedReference keyRef = (KeyedReference)keyRefs.elementAt(categoryID);
                String tModelKeyValue = null;
                if (keyRef.getTModelKey() != null) {
                    tModelKeyValue = keyRef.getTModelKey().toString();
                }
                statement.setInt(2, categoryID);
                statement.setString(3, tModelKeyValue);
                statement.setString(4, keyRef.getKeyName());
                statement.setString(5, keyRef.getKeyValue());
                log.debug((Object)("insert into BINDING_CATEGORY table:\n\n\t" + insertSQL + "\n\t BINDING_KEY=" + bindingKey.toString() + "\n\t CATEGORY_ID=" + categoryID + "\n\t TMODEL_KEY_REF=" + tModelKeyValue + "\n\t KEY_NAME=" + keyRef.getKeyName() + "\n\t KEY_VALUE=" + keyRef.getKeyValue() + "\n"));
                statement.executeUpdate();
            }
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector select(String bindingKey, Connection connection) throws SQLException {
        Vector<KeyedReference> keyRefList = new Vector<KeyedReference>();
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.prepareStatement(selectSQL);
            statement.setString(1, bindingKey.toString());
            log.debug((Object)("select from BINDING_CATEGORY table:\n\n\t" + selectSQL + "\n\t BINDING_KEY=" + bindingKey.toString() + "\n"));
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                KeyedReference keyRef = new KeyedReference();
                keyRef.setTModelKey(resultSet.getString(1));
                keyRef.setKeyName(resultSet.getString(2));
                keyRef.setKeyValue(resultSet.getString(3));
                keyRefList.add(keyRef);
            }
            Vector<KeyedReference> vector = keyRefList;
            return vector;
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delete(String bindingKey, Connection connection) throws SQLException {
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(deleteSQL);
            statement.setString(1, bindingKey.toString());
            log.debug((Object)("delete from BINDING_CATEGORY table:\n\n\t" + deleteSQL + "\n\t BINDING_KEY=" + bindingKey.toString() + "\n"));
            statement.executeUpdate();
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Config.setStringProperty("juddi.useConnectionPool", "true");
        Connection conn = null;
        try {
            conn = ConnectionManager.aquireConnection();
            BindingCategoryTable.test(conn);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    public static void test(Connection connection) throws Exception {
        Transaction txn = new Transaction();
        UUIDGen uuidgen = UUIDGenFactory.getUUIDGen();
        if (connection != null) {
            try {
                String businessKey = uuidgen.uuidgen();
                BusinessEntity business = new BusinessEntity();
                business.setBusinessKey(businessKey);
                business.setAuthorizedName("sviens");
                business.setOperator("WebServiceRegistry.com");
                String serviceKey = uuidgen.uuidgen();
                BusinessService service = new BusinessService();
                service.setServiceKey(serviceKey);
                service.setBusinessKey(businessKey);
                String bindingKey = uuidgen.uuidgen();
                BindingTemplate binding = new BindingTemplate();
                binding.setAccessPoint(new AccessPoint("http://www.juddi.org/binding.html", "http"));
                binding.setHostingRedirector(null);
                binding.setBindingKey(bindingKey);
                binding.setServiceKey(serviceKey);
                Vector keyRefs = new Vector();
                keyRefs.add(new KeyedReference("uuid:" + uuidgen.uuidgen(), "alpha", "abcdefghi"));
                keyRefs.add(new KeyedReference("uuid:" + uuidgen.uuidgen(), "beta", "jklmnopqr"));
                keyRefs.add(new KeyedReference("uuid:" + uuidgen.uuidgen(), "omega", "stuvwxyz"));
                String authorizedUserID = "sviens";
                txn.begin(connection);
                BusinessEntityTable.insert(business, authorizedUserID, connection);
                BusinessServiceTable.insert(service, connection);
                BindingTemplateTable.insert(binding, connection);
                BindingCategoryTable.insert(bindingKey, keyRefs, connection);
                keyRefs = BindingCategoryTable.select(bindingKey, connection);
                for (int i = 0; i < keyRefs.size(); ++i) {
                    KeyedReference keyRef = (KeyedReference)keyRefs.elementAt(i);
                    System.out.println(" Key Name: " + keyRef.getKeyName());
                    System.out.println("Key Value: " + keyRef.getKeyValue());
                    System.out.println("TModelKey: " + keyRef.getTModelKey());
                }
                BindingCategoryTable.delete(bindingKey, connection);
                keyRefs = BindingCategoryTable.select(bindingKey, connection);
                txn.commit();
            }
            catch (Exception ex) {
                try {
                    txn.rollback();
                }
                catch (SQLException sqlex) {
                    sqlex.printStackTrace();
                }
                throw ex;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        StringBuffer sql = null;
        sql = new StringBuffer(150);
        sql.append("INSERT INTO BINDING_CATEGORY (");
        sql.append("BINDING_KEY,");
        sql.append("CATEGORY_ID,");
        sql.append("TMODEL_KEY_REF,");
        sql.append("KEY_NAME,");
        sql.append("KEY_VALUE) ");
        sql.append("VALUES (?,?,?,?,?)");
        insertSQL = sql.toString();
        sql = new StringBuffer(200);
        sql.append("SELECT ");
        sql.append("TMODEL_KEY_REF,");
        sql.append("KEY_NAME,");
        sql.append("KEY_VALUE, ");
        sql.append("CATEGORY_ID ");
        sql.append("FROM BINDING_CATEGORY ");
        sql.append("WHERE BINDING_KEY=? ");
        sql.append("ORDER BY CATEGORY_ID");
        selectSQL = sql.toString();
        sql = new StringBuffer(100);
        sql.append("DELETE FROM BINDING_CATEGORY ");
        sql.append("WHERE BINDING_KEY=?");
        deleteSQL = sql.toString();
    }
}

