/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.datastore.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datastore.jdbc.BusinessEntityTable;
import org.apache.juddi.datastore.jdbc.BusinessServiceTable;
import org.apache.juddi.datatype.binding.AccessPoint;
import org.apache.juddi.datatype.binding.BindingTemplate;
import org.apache.juddi.datatype.binding.HostingRedirector;
import org.apache.juddi.datatype.business.BusinessEntity;
import org.apache.juddi.datatype.service.BusinessService;
import org.apache.juddi.util.Config;
import org.apache.juddi.util.jdbc.ConnectionManager;
import org.apache.juddi.util.jdbc.Transaction;
import org.apache.juddi.uuidgen.UUIDGen;
import org.apache.juddi.uuidgen.UUIDGenFactory;

class BindingTemplateTable {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$juddi$datastore$jdbc$BindingTemplateTable == null ? (class$org$apache$juddi$datastore$jdbc$BindingTemplateTable = BindingTemplateTable.class$("org.apache.juddi.datastore.jdbc.BindingTemplateTable")) : class$org$apache$juddi$datastore$jdbc$BindingTemplateTable));
    static String insertSQL = null;
    static String deleteSQL = null;
    static String selectSQL = null;
    static String selectByServiceKeySQL = null;
    static String deleteByServiceKeySQL = null;
    static String verifyOwnershipSQL = null;
    static /* synthetic */ Class class$org$apache$juddi$datastore$jdbc$BindingTemplateTable;

    BindingTemplateTable() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insert(BindingTemplate binding, Connection connection) throws SQLException {
        Statement statement = null;
        Timestamp timeStamp = new Timestamp(System.currentTimeMillis());
        try {
            String urlType = null;
            String url = null;
            AccessPoint accessPoint = binding.getAccessPoint();
            if (accessPoint != null) {
                urlType = accessPoint.getURLType();
                url = accessPoint.getURL();
            }
            String redirectorKey = null;
            HostingRedirector redirector = binding.getHostingRedirector();
            if (redirector != null && redirector.getBindingKey() != null) {
                redirectorKey = redirector.getBindingKey();
            }
            statement = connection.prepareStatement(insertSQL);
            statement.setString(1, binding.getServiceKey().toString());
            statement.setString(2, binding.getBindingKey().toString());
            statement.setString(3, urlType);
            statement.setString(4, url);
            statement.setString(5, redirectorKey);
            statement.setTimestamp(6, timeStamp);
            log.debug((Object)("insert into BINDING_TEMPLATE table:\n\n\t" + insertSQL + "\n\t SERVICE_KEY=" + binding.getServiceKey().toString() + "\n\t BINDING_KEY=" + binding.getBindingKey().toString() + "\n\t ACCESS_POINT_TYPE=" + urlType + "\n\t ACCESS_POINT_URL=" + url + "\n\t HOSTING_REDIRECTOR=" + redirectorKey + "\n\t LAST_UPDATE=" + timeStamp.getTime() + "\n"));
            statement.executeUpdate();
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delete(String bindingKey, Connection connection) throws SQLException {
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(deleteSQL);
            statement.setString(1, bindingKey);
            log.debug((Object)("delete from BINDING_TEMPLATE table:\n\n\t" + deleteSQL + "\n\t BINDING_KEY=" + bindingKey + "\n"));
            statement.executeUpdate();
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BindingTemplate select(String bindingKey, Connection connection) throws SQLException {
        BindingTemplate binding = null;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.prepareStatement(selectSQL);
            statement.setString(1, bindingKey.toString());
            log.debug((Object)("select from BINDING_TEMPLATE table:\n\n\t" + selectSQL + "\n\t BINDING_KEY=" + bindingKey.toString() + "\n"));
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                String redirectorKey;
                binding = new BindingTemplate();
                binding.setServiceKey(resultSet.getString(1));
                binding.setBindingKey(bindingKey);
                String urlType = resultSet.getString(2);
                String url = resultSet.getString(3);
                if (urlType != null && url != null) {
                    binding.setAccessPoint(new AccessPoint(urlType, url));
                }
                if ((redirectorKey = resultSet.getString(4)) != null) {
                    binding.setHostingRedirector(new HostingRedirector(redirectorKey));
                }
            }
            BindingTemplate bindingTemplate = binding;
            return bindingTemplate;
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception e) {}
            try {
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector selectByServiceKey(String serviceKey, Connection connection) throws SQLException {
        Vector<BindingTemplate> bindList = new Vector<BindingTemplate>();
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.prepareStatement(selectByServiceKeySQL);
            statement.setString(1, serviceKey.toString());
            log.debug((Object)("select from BINDING_TEMPLATE table:\n\n\t" + selectByServiceKeySQL + "\n\t SERVICE_KEY=" + serviceKey.toString() + "\n"));
            resultSet = statement.executeQuery();
            BindingTemplate binding = null;
            while (resultSet.next()) {
                String redirectorKey;
                binding = new BindingTemplate();
                binding.setServiceKey(serviceKey);
                binding.setBindingKey(resultSet.getString(1));
                String urlType = resultSet.getString(2);
                String url = resultSet.getString(3);
                if (urlType != null && url != null) {
                    binding.setAccessPoint(new AccessPoint(urlType, url));
                }
                if ((redirectorKey = resultSet.getString(4)) != null) {
                    binding.setHostingRedirector(new HostingRedirector(redirectorKey));
                }
                bindList.add(binding);
                binding = null;
            }
            Vector<BindingTemplate> vector = bindList;
            return vector;
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception e) {}
            try {
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteByServiceKey(String serviceKey, Connection connection) throws SQLException {
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(deleteByServiceKeySQL);
            statement.setString(1, serviceKey.toString());
            log.debug((Object)("delete from BINDING_TEMPLATE table:\n\n\t" + deleteByServiceKeySQL + "\n\t SERVICE_KEY=" + serviceKey.toString() + "\n"));
            int returnCode = statement.executeUpdate();
            log.info((Object)("delete was successful, rows deleted=" + returnCode));
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean verifyOwnership(String bindingKey, String publisherID, Connection connection) throws SQLException {
        if (bindingKey == null || publisherID == null) {
            return false;
        }
        boolean authorized = false;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.prepareStatement(verifyOwnershipSQL);
            statement.setString(1, bindingKey);
            statement.setString(2, publisherID);
            log.debug((Object)("checking ownership of BINDING_TEMPLATE:\n\n\t" + verifyOwnershipSQL + "\n\t BINDNG_KEY=" + bindingKey + "\n\t PUBLISHER_ID=" + publisherID + "\n"));
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                authorized = true;
            }
            boolean bl = authorized;
            return bl;
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception e) {}
            try {
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Config.setStringProperty("juddi.useConnectionPool", "true");
        Connection conn = null;
        try {
            conn = ConnectionManager.aquireConnection();
            BindingTemplateTable.test(conn);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    public static void test(Connection connection) throws Exception {
        Transaction txn = new Transaction();
        UUIDGen uuidgen = UUIDGenFactory.getUUIDGen();
        if (connection != null) {
            try {
                String businessKey = uuidgen.uuidgen();
                BusinessEntity business = new BusinessEntity();
                business.setBusinessKey(businessKey);
                business.setAuthorizedName("sviens");
                business.setOperator("WebServiceRegistry.com");
                String serviceKey = uuidgen.uuidgen();
                BusinessService service = new BusinessService();
                service.setBusinessKey(businessKey);
                service.setServiceKey(serviceKey);
                String bindingKey = uuidgen.uuidgen();
                BindingTemplate binding = new BindingTemplate();
                binding.setServiceKey(serviceKey);
                binding.setBindingKey(bindingKey);
                binding.setAccessPoint(new AccessPoint("http", "http://juddi.org/bindingtemplate.html"));
                String authorizedUserID = "sviens";
                txn.begin(connection);
                BusinessEntityTable.insert(business, authorizedUserID, connection);
                BusinessServiceTable.insert(service, connection);
                BindingTemplateTable.insert(binding, connection);
                binding.setBindingKey(uuidgen.uuidgen());
                BindingTemplateTable.insert(binding, connection);
                binding.setBindingKey(uuidgen.uuidgen());
                BindingTemplateTable.insert(binding, connection);
                binding = BindingTemplateTable.select(bindingKey, connection);
                BindingTemplateTable.delete(bindingKey, connection);
                binding = BindingTemplateTable.select(bindingKey, connection);
                BindingTemplateTable.selectByServiceKey(serviceKey, connection);
                BindingTemplateTable.deleteByServiceKey(serviceKey, connection);
                BindingTemplateTable.selectByServiceKey(serviceKey, connection);
                txn.commit();
            }
            catch (Exception ex) {
                try {
                    txn.rollback();
                }
                catch (SQLException sqlex) {
                    sqlex.printStackTrace();
                }
                throw ex;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        StringBuffer sql = null;
        sql = new StringBuffer(150);
        sql.append("INSERT INTO BINDING_TEMPLATE (");
        sql.append("SERVICE_KEY,");
        sql.append("BINDING_KEY,");
        sql.append("ACCESS_POINT_TYPE,");
        sql.append("ACCESS_POINT_URL,");
        sql.append("HOSTING_REDIRECTOR,");
        sql.append("LAST_UPDATE) ");
        sql.append("VALUES (?,?,?,?,?,?)");
        insertSQL = sql.toString();
        sql = new StringBuffer(100);
        sql.append("DELETE FROM BINDING_TEMPLATE ");
        sql.append("WHERE BINDING_KEY=?");
        deleteSQL = sql.toString();
        sql = new StringBuffer(200);
        sql.append("SELECT ");
        sql.append("SERVICE_KEY,");
        sql.append("ACCESS_POINT_TYPE,");
        sql.append("ACCESS_POINT_URL,");
        sql.append("HOSTING_REDIRECTOR ");
        sql.append("FROM BINDING_TEMPLATE ");
        sql.append("WHERE BINDING_KEY=?");
        selectSQL = sql.toString();
        sql = new StringBuffer(200);
        sql.append("SELECT ");
        sql.append("BINDING_KEY,");
        sql.append("ACCESS_POINT_TYPE,");
        sql.append("ACCESS_POINT_URL,");
        sql.append("HOSTING_REDIRECTOR ");
        sql.append("FROM BINDING_TEMPLATE ");
        sql.append("WHERE SERVICE_KEY=?");
        selectByServiceKeySQL = sql.toString();
        sql = new StringBuffer(100);
        sql.append("DELETE FROM BINDING_TEMPLATE ");
        sql.append("WHERE SERVICE_KEY=?");
        deleteByServiceKeySQL = sql.toString();
        sql = new StringBuffer(200);
        sql.append("SELECT ");
        sql.append("* ");
        sql.append("FROM BUSINESS_ENTITY e, BUSINESS_SERVICE s, BINDING_TEMPLATE t ");
        sql.append("WHERE s.SERVICE_KEY = t.SERVICE_KEY ");
        sql.append("AND e.BUSINESS_KEY = s.BUSINESS_KEY ");
        sql.append("AND t.BINDING_KEY=? ");
        sql.append("AND e.PUBLISHER_ID=?");
        verifyOwnershipSQL = sql.toString();
    }
}

