/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.datastore.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datastore.jdbc.BusinessEntityTable;
import org.apache.juddi.datastore.jdbc.ContactTable;
import org.apache.juddi.datatype.Description;
import org.apache.juddi.datatype.business.BusinessEntity;
import org.apache.juddi.datatype.business.Contact;
import org.apache.juddi.datatype.business.Contacts;
import org.apache.juddi.util.Config;
import org.apache.juddi.util.jdbc.ConnectionManager;
import org.apache.juddi.util.jdbc.Transaction;
import org.apache.juddi.uuidgen.UUIDGen;
import org.apache.juddi.uuidgen.UUIDGenFactory;

class ContactDescTable {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$juddi$datastore$jdbc$ContactDescTable == null ? (class$org$apache$juddi$datastore$jdbc$ContactDescTable = ContactDescTable.class$("org.apache.juddi.datastore.jdbc.ContactDescTable")) : class$org$apache$juddi$datastore$jdbc$ContactDescTable));
    static String insertSQL = null;
    static String selectSQL = null;
    static String deleteSQL = null;
    static /* synthetic */ Class class$org$apache$juddi$datastore$jdbc$ContactDescTable;

    ContactDescTable() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insert(String businessKey, int contactID, Vector descList, Connection connection) throws SQLException {
        if (descList == null || descList.size() == 0) {
            return;
        }
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(insertSQL);
            statement.setString(1, businessKey.toString());
            statement.setInt(2, contactID);
            int listSize = descList.size();
            for (int descID = 0; descID < listSize; ++descID) {
                Description desc = (Description)descList.elementAt(descID);
                statement.setInt(3, descID);
                statement.setString(4, desc.getLanguageCode());
                statement.setString(5, desc.getValue());
                log.debug((Object)("insert into CONTACT_DESCR table:\n\n\t" + insertSQL + "\n\t BUSINESS_KEY=" + businessKey.toString() + "\n\t CONTACT_ID=" + contactID + "\n\t CONTACT_DESCR_ID=" + descID + "\n\t LANG_CODE=" + desc.getLanguageCode() + "\n\t DESCR=" + desc.getValue() + "\n"));
                statement.executeUpdate();
            }
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector select(String businessKey, int contactID, Connection connection) throws SQLException {
        Vector<Description> descList = new Vector<Description>();
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.prepareStatement(selectSQL);
            statement.setString(1, businessKey.toString());
            statement.setInt(2, contactID);
            log.debug((Object)("select from CONTACT_DESCR table:\n\n\t" + selectSQL + "\n\t BUSINESS_KEY=" + businessKey.toString() + "\n\t CONTACT_KEY=" + contactID + "\n"));
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                Description desc = new Description();
                desc.setLanguageCode(resultSet.getString(1));
                desc.setValue(resultSet.getString(2));
                descList.add(desc);
            }
            Vector<Description> vector = descList;
            return vector;
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delete(String businessKey, Connection connection) throws SQLException {
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(deleteSQL);
            statement.setString(1, businessKey.toString());
            log.debug((Object)("delet from CONTACT_DESCR table:\n\n\t" + deleteSQL + "\n\t BUSINESS_KEY=" + businessKey.toString() + "\n"));
            statement.executeUpdate();
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Config.setStringProperty("juddi.useConnectionPool", "true");
        Connection conn = null;
        try {
            conn = ConnectionManager.aquireConnection();
            ContactDescTable.test(conn);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    public static void test(Connection connection) throws Exception {
        Transaction txn = new Transaction();
        UUIDGen uuidgen = UUIDGenFactory.getUUIDGen();
        if (connection != null) {
            try {
                Vector descList = new Vector();
                descList.add(new Description("blah, blah, blah", "en"));
                descList.add(new Description("Yadda, Yadda, Yadda", "it"));
                descList.add(new Description("WhoobWhoobWhoobWhoob", "cy"));
                descList.add(new Description("Haachachachacha", "km"));
                Contact contact = new Contact("Anthony Michaels");
                contact.setUseType("sales");
                contact.setDescriptionVector(descList);
                Vector<Contact> contactList = new Vector<Contact>();
                contactList.add(contact);
                Contacts contacts = new Contacts();
                contacts.setContactVector(contactList);
                String businessKey = uuidgen.uuidgen();
                BusinessEntity business = new BusinessEntity();
                business.setBusinessKey(businessKey);
                business.setAuthorizedName("sviens");
                business.setOperator("WebServiceRegistry.com");
                business.setContacts(contacts);
                int contactID = 0;
                txn.begin(connection);
                String authorizedUserID = "sviens";
                BusinessEntityTable.insert(business, authorizedUserID, connection);
                ContactTable.insert(businessKey, contactList, connection);
                ContactDescTable.insert(businessKey, contactID, descList, connection);
                descList = ContactDescTable.select(businessKey, contactID, connection);
                ContactDescTable.delete(businessKey, connection);
                descList = ContactDescTable.select(businessKey, contactID, connection);
                txn.commit();
            }
            catch (Exception ex) {
                try {
                    txn.rollback();
                }
                catch (SQLException sqlex) {
                    sqlex.printStackTrace();
                }
                throw ex;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        StringBuffer sql = null;
        sql = new StringBuffer(150);
        sql.append("INSERT INTO CONTACT_DESCR (");
        sql.append("BUSINESS_KEY,");
        sql.append("CONTACT_ID,");
        sql.append("CONTACT_DESCR_ID,");
        sql.append("LANG_CODE,");
        sql.append("DESCR) ");
        sql.append("VALUES (?,?,?,?,?)");
        insertSQL = sql.toString();
        sql = new StringBuffer(200);
        sql.append("SELECT ");
        sql.append("LANG_CODE,");
        sql.append("DESCR, ");
        sql.append("CONTACT_DESCR_ID ");
        sql.append("FROM CONTACT_DESCR ");
        sql.append("WHERE BUSINESS_KEY=? ");
        sql.append("AND CONTACT_ID=? ");
        sql.append("ORDER BY CONTACT_DESCR_ID");
        selectSQL = sql.toString();
        sql = new StringBuffer(100);
        sql.append("DELETE FROM CONTACT_DESCR ");
        sql.append("WHERE BUSINESS_KEY=?");
        deleteSQL = sql.toString();
    }
}

