/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.datastore.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datastore.jdbc.BusinessEntityTable;
import org.apache.juddi.datatype.business.BusinessEntity;
import org.apache.juddi.datatype.business.Contact;
import org.apache.juddi.util.Config;
import org.apache.juddi.util.jdbc.ConnectionManager;
import org.apache.juddi.util.jdbc.Transaction;
import org.apache.juddi.uuidgen.UUIDGen;
import org.apache.juddi.uuidgen.UUIDGenFactory;

class ContactTable {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$juddi$datastore$jdbc$ContactTable == null ? (class$org$apache$juddi$datastore$jdbc$ContactTable = ContactTable.class$("org.apache.juddi.datastore.jdbc.ContactTable")) : class$org$apache$juddi$datastore$jdbc$ContactTable));
    static String insertSQL = null;
    static String selectSQL = null;
    static String deleteSQL = null;
    static /* synthetic */ Class class$org$apache$juddi$datastore$jdbc$ContactTable;

    ContactTable() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insert(String businessKey, Vector contactList, Connection connection) throws SQLException {
        if (contactList == null || contactList.size() == 0) {
            return;
        }
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(insertSQL);
            statement.setString(1, businessKey.toString());
            int listSize = contactList.size();
            for (int contactID = 0; contactID < listSize; ++contactID) {
                Contact contact = (Contact)contactList.elementAt(contactID);
                statement.setInt(2, contactID);
                statement.setString(3, contact.getUseType());
                statement.setString(4, contact.getPersonNameValue());
                log.debug((Object)("insert into CONTACT table:\n\n\t" + insertSQL + "\n\t BUSINESS_KEY=" + businessKey.toString() + "\n\t CONTACT_ID=" + contactID + "\n\t USE_TYPE=" + contact.getUseType() + "\n\t PERSON_NAME=" + contact.getPersonNameValue() + "\n"));
                statement.executeUpdate();
            }
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector select(String businessKey, Connection connection) throws SQLException {
        Vector<Contact> contactList = new Vector<Contact>();
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.prepareStatement(selectSQL);
            statement.setString(1, businessKey.toString());
            log.debug((Object)("select from CONTACT table:\n\n\t" + selectSQL + "\n\t BUSINESS_KEY=" + businessKey.toString() + "\n"));
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                Contact contact = new Contact();
                contact.setUseType(resultSet.getString(1));
                contact.setPersonNameValue(resultSet.getString(2));
                contactList.add(contact);
            }
            Vector<Contact> vector = contactList;
            return vector;
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delete(String businessKey, Connection connection) throws SQLException {
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(deleteSQL);
            statement.setString(1, businessKey.toString());
            log.debug((Object)("delete from CONTACT table:\n\n\t" + deleteSQL + "\n\t BUSINESS_KEY=" + businessKey.toString() + "\n"));
            statement.executeUpdate();
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Config.setStringProperty("juddi.useConnectionPool", "true");
        Connection conn = null;
        try {
            conn = ConnectionManager.aquireConnection();
            ContactTable.test(conn);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    public static void test(Connection connection) throws Exception {
        Transaction txn = new Transaction();
        UUIDGen uuidgen = UUIDGenFactory.getUUIDGen();
        if (connection != null) {
            try {
                String businessKey = uuidgen.uuidgen();
                BusinessEntity business = new BusinessEntity();
                business.setBusinessKey(businessKey);
                business.setAuthorizedName("sviens");
                business.setOperator("www.jUDDI.org");
                Vector contactList = new Vector();
                Contact contact = null;
                contact = new Contact("Steve Viens");
                contact.setUseType("sales");
                contactList.add(contact);
                contact = new Contact("Marley Viens");
                contact.setUseType("support");
                contactList.add(contact);
                contact = new Contact("Chris Michaels");
                contact.setUseType("marketing");
                contactList.add(contact);
                String authorizedUserID = "sviens";
                txn.begin(connection);
                BusinessEntityTable.insert(business, authorizedUserID, connection);
                ContactTable.insert(businessKey, contactList, connection);
                contactList = ContactTable.select(businessKey, connection);
                System.out.println(contactList.size() + " contacts for BusinessKey: " + businessKey);
                ContactTable.delete(businessKey, connection);
                contactList = ContactTable.select(businessKey, connection);
                System.out.println(contactList.size() + " contacts for BusinessKey: " + businessKey);
                txn.commit();
            }
            catch (Exception ex) {
                try {
                    txn.rollback();
                }
                catch (SQLException sqlex) {
                    sqlex.printStackTrace();
                }
                throw ex;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        StringBuffer sql = null;
        sql = new StringBuffer(150);
        sql.append("INSERT INTO CONTACT (");
        sql.append("BUSINESS_KEY,");
        sql.append("CONTACT_ID,");
        sql.append("USE_TYPE,");
        sql.append("PERSON_NAME) ");
        sql.append("VALUES (?,?,?,?)");
        insertSQL = sql.toString();
        sql = new StringBuffer(200);
        sql.append("SELECT ");
        sql.append("USE_TYPE,");
        sql.append("PERSON_NAME, ");
        sql.append("CONTACT_ID ");
        sql.append("FROM CONTACT ");
        sql.append("WHERE BUSINESS_KEY=? ");
        sql.append("ORDER BY CONTACT_ID");
        selectSQL = sql.toString();
        sql = new StringBuffer(100);
        sql.append("DELETE FROM CONTACT ");
        sql.append("WHERE BUSINESS_KEY=?");
        deleteSQL = sql.toString();
    }
}

