/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.datastore.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datastore.jdbc.BusinessEntityTable;
import org.apache.juddi.datastore.jdbc.ContactTable;
import org.apache.juddi.datatype.Email;
import org.apache.juddi.datatype.business.BusinessEntity;
import org.apache.juddi.datatype.business.Contact;
import org.apache.juddi.util.Config;
import org.apache.juddi.util.jdbc.ConnectionManager;
import org.apache.juddi.util.jdbc.Transaction;
import org.apache.juddi.uuidgen.UUIDGen;
import org.apache.juddi.uuidgen.UUIDGenFactory;

class EmailTable {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$juddi$datastore$jdbc$EmailTable == null ? (class$org$apache$juddi$datastore$jdbc$EmailTable = EmailTable.class$("org.apache.juddi.datastore.jdbc.EmailTable")) : class$org$apache$juddi$datastore$jdbc$EmailTable));
    static String insertSQL = null;
    static String selectSQL = null;
    static String deleteSQL = null;
    static /* synthetic */ Class class$org$apache$juddi$datastore$jdbc$EmailTable;

    EmailTable() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insert(String businessKey, int contactID, Vector emailList, Connection connection) throws SQLException {
        if (emailList == null || emailList.size() == 0) {
            return;
        }
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(insertSQL);
            statement.setString(1, businessKey.toString());
            statement.setInt(2, contactID);
            int listSize = emailList.size();
            for (int emailID = 0; emailID < listSize; ++emailID) {
                Email email = (Email)emailList.elementAt(emailID);
                statement.setInt(3, emailID);
                statement.setString(4, email.getUseType());
                statement.setString(5, email.getValue());
                log.debug((Object)("insert into EMAIL table:\n\n\t" + insertSQL + "\n\t BUSINESS_KEY=" + businessKey.toString() + "\n\t CONTACT_ID=" + contactID + "\n\t EMAIL_ID=" + emailID + "\n\t USE_TYPE=" + email.getUseType() + "\n\t EMAIL_ADDRESS=" + email.getValue() + "\n"));
                statement.executeUpdate();
            }
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector select(String businessKey, int contactID, Connection connection) throws SQLException {
        Vector<Email> emailList = new Vector<Email>();
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.prepareStatement(selectSQL);
            statement.setString(1, businessKey.toString());
            statement.setInt(2, contactID);
            log.debug((Object)("select from EMAIL table:\n\n\t" + selectSQL + "\n\t BUSINESS_KEY=" + businessKey.toString() + "\n\t CONTACT_ID=" + contactID + "\n"));
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                Email email = new Email();
                email.setUseType(resultSet.getString(1));
                email.setValue(resultSet.getString(2));
                emailList.add(email);
            }
            Vector<Email> vector = emailList;
            return vector;
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delete(String businessKey, Connection connection) throws SQLException {
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(deleteSQL);
            statement.setString(1, businessKey.toString());
            log.debug((Object)("delete from EMAIL table:\n\n\t" + deleteSQL + "\n\t BUSINESS_KEY=" + businessKey.toString() + "\n"));
            statement.executeUpdate();
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Config.setStringProperty("juddi.useConnectionPool", "true");
        Connection conn = null;
        try {
            conn = ConnectionManager.aquireConnection();
            EmailTable.test(conn);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    public static void test(Connection connection) throws Exception {
        Transaction txn = new Transaction();
        UUIDGen uuidgen = UUIDGenFactory.getUUIDGen();
        if (connection != null) {
            try {
                String businessKey = uuidgen.uuidgen();
                BusinessEntity business = new BusinessEntity();
                business.setBusinessKey(businessKey);
                business.setAuthorizedName("sviens");
                business.setOperator("WebServiceRegistry.com");
                Vector<Contact> contactList = new Vector<Contact>();
                Contact contact = new Contact("Billy Bob");
                contact.setUseType("server");
                contactList.add(contact);
                int contactID = 0;
                Vector emailList = new Vector();
                Email email = null;
                email = new Email("support@steveviens.com");
                email.setUseType("Support");
                emailList.add(email);
                email = new Email("marketing@steveviens.com");
                email.setUseType("Advertising");
                emailList.add(email);
                email = new Email("info@steveviens.com");
                email.setUseType("Information");
                emailList.add(email);
                email = new Email("admin@steveviens.com");
                email.setUseType("Administration");
                emailList.add(email);
                email = new Email("webmaster@steveviens.com");
                email.setUseType("Web Master");
                emailList.add(email);
                String authorizedUserID = "sviens";
                txn.begin(connection);
                BusinessEntityTable.insert(business, authorizedUserID, connection);
                ContactTable.insert(businessKey, contactList, connection);
                EmailTable.insert(businessKey, contactID, emailList, connection);
                emailList = EmailTable.select(businessKey, contactID, connection);
                EmailTable.delete(businessKey, connection);
                emailList = EmailTable.select(businessKey, contactID, connection);
                txn.commit();
            }
            catch (Exception ex) {
                try {
                    txn.rollback();
                }
                catch (SQLException sqlex) {
                    sqlex.printStackTrace();
                }
                throw ex;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        StringBuffer sql = null;
        sql = new StringBuffer(150);
        sql.append("INSERT INTO EMAIL (");
        sql.append("BUSINESS_KEY,");
        sql.append("CONTACT_ID,");
        sql.append("EMAIL_ID,");
        sql.append("USE_TYPE,");
        sql.append("EMAIL_ADDRESS) ");
        sql.append("VALUES (?,?,?,?,?)");
        insertSQL = sql.toString();
        sql = new StringBuffer(200);
        sql.append("SELECT ");
        sql.append("USE_TYPE,");
        sql.append("EMAIL_ADDRESS, ");
        sql.append("EMAIL_ID ");
        sql.append("FROM EMAIL ");
        sql.append("WHERE BUSINESS_KEY=? ");
        sql.append("AND CONTACT_ID=? ");
        sql.append("ORDER BY EMAIL_ID");
        selectSQL = sql.toString();
        sql = new StringBuffer(100);
        sql.append("DELETE FROM EMAIL ");
        sql.append("WHERE BUSINESS_KEY=?");
        deleteSQL = sql.toString();
    }
}

