/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.datastore.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datatype.IdentifierBag;
import org.apache.juddi.datatype.KeyedReference;
import org.apache.juddi.datatype.request.FindQualifiers;
import org.apache.juddi.util.Config;
import org.apache.juddi.util.jdbc.ConnectionManager;
import org.apache.juddi.util.jdbc.DynamicQuery;
import org.apache.juddi.util.jdbc.Transaction;

class FindBusinessByIdentifierQuery {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$juddi$datastore$jdbc$FindBusinessByIdentifierQuery == null ? (class$org$apache$juddi$datastore$jdbc$FindBusinessByIdentifierQuery = FindBusinessByIdentifierQuery.class$("org.apache.juddi.datastore.jdbc.FindBusinessByIdentifierQuery")) : class$org$apache$juddi$datastore$jdbc$FindBusinessByIdentifierQuery));
    static String selectSQL;
    static /* synthetic */ Class class$org$apache$juddi$datastore$jdbc$FindBusinessByIdentifierQuery;

    FindBusinessByIdentifierQuery() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector select(IdentifierBag identifierBag, Vector keysIn, FindQualifiers qualifiers, Connection connection) throws SQLException {
        Vector<String> vector;
        if (keysIn != null && keysIn.size() == 0) {
            return keysIn;
        }
        Vector<String> keysOut = new Vector<String>();
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        DynamicQuery sql = new DynamicQuery(selectSQL);
        FindBusinessByIdentifierQuery.appendWhere(sql, identifierBag, qualifiers);
        FindBusinessByIdentifierQuery.appendIn(sql, keysIn);
        FindBusinessByIdentifierQuery.appendOrderBy(sql, qualifiers);
        try {
            log.debug((Object)sql.toString());
            statement = sql.buildPreparedStatement(connection);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                keysOut.addElement(resultSet.getString(1));
            }
            vector = keysOut;
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            try {
                resultSet.close();
            }
            catch (Exception e) {
                log.warn((Object)("An Exception was encountered while attempting to close the Find BusinessEntity ResultSet: " + e.getMessage()), (Throwable)e);
            }
            try {
                statement.close();
            }
            catch (Exception e) {
                log.warn((Object)("An Exception was encountered while attempting to close the Find BusinessEntity Statement: " + e.getMessage()), (Throwable)e);
            }
            throw throwable;
        }
        try {
            resultSet.close();
        }
        catch (Exception e) {
            log.warn((Object)("An Exception was encountered while attempting to close the Find BusinessEntity ResultSet: " + e.getMessage()), (Throwable)e);
        }
        try {
            statement.close();
        }
        catch (Exception e) {
            log.warn((Object)("An Exception was encountered while attempting to close the Find BusinessEntity Statement: " + e.getMessage()), (Throwable)e);
        }
        return vector;
    }

    private static void appendWhere(DynamicQuery sql, IdentifierBag identifierBag, FindQualifiers qualifiers) {
        int vectorSize;
        Vector keyedRefVector;
        sql.append("WHERE B.BUSINESS_KEY = I.BUSINESS_KEY ");
        if (identifierBag != null && (keyedRefVector = identifierBag.getKeyedReferenceVector()) != null && (vectorSize = keyedRefVector.size()) > 0) {
            sql.append("AND (");
            for (int i = 0; i < vectorSize; ++i) {
                String value;
                KeyedReference keyedRef = (KeyedReference)keyedRefVector.elementAt(i);
                String key = keyedRef.getTModelKey();
                if (key == null) {
                    key = "";
                }
                if ((value = keyedRef.getKeyValue()) == null) {
                    value = "";
                }
                sql.append("(I.TMODEL_KEY_REF = ? AND I.KEY_VALUE = ?)");
                sql.addValue(key);
                sql.addValue(value);
                if (i + 1 >= vectorSize) continue;
                sql.append(" OR ");
            }
            sql.append(") ");
        }
    }

    private static void appendIn(DynamicQuery sql, Vector keysIn) {
        if (keysIn == null) {
            return;
        }
        sql.append("AND B.BUSINESS_KEY IN (");
        int keyCount = keysIn.size();
        for (int i = 0; i < keyCount; ++i) {
            String key = (String)keysIn.elementAt(i);
            sql.append("?");
            sql.addValue(key);
            if (i + 1 >= keyCount) continue;
            sql.append(",");
        }
        sql.append(") ");
    }

    private static void appendOrderBy(DynamicQuery sql, FindQualifiers qualifiers) {
        sql.append("ORDER BY ");
        if (qualifiers == null) {
            sql.append("B.LAST_UPDATE DESC");
        } else if (qualifiers.sortByDateAsc) {
            sql.append("B.LAST_UPDATE ASC");
        } else {
            sql.append("B.LAST_UPDATE DESC");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Config.setStringProperty("juddi.useConnectionPool", "true");
        Connection conn = null;
        try {
            conn = ConnectionManager.aquireConnection();
            FindBusinessByIdentifierQuery.test(conn);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    public static void test(Connection connection) throws Exception {
        IdentifierBag identifierBag = new IdentifierBag();
        Vector<KeyedReference> keyedRefVector = new Vector<KeyedReference>();
        keyedRefVector.addElement(new KeyedReference("af176f34-00ca-4d93-97f8-2b62aa3a75e5", "blah, blah, blah"));
        keyedRefVector.addElement(new KeyedReference("54a827e0-1b51-4381-8775-ad02c377bb25", "Haachachachacha"));
        keyedRefVector.addElement(new KeyedReference("xxxxxxxxxxxxxxxx", "xxxxxxxxxxx"));
        identifierBag.setKeyedReferenceVector(keyedRefVector);
        Vector<String> keysIn = new Vector<String>();
        keysIn.add("824c73af-22e0-4816-9689-2429101c7727");
        keysIn.add("c311085b-3277-470d-8ce9-07b81c484e4b");
        keysIn.add("6b368a5a-6a62-4f23-a002-f11e22780a91");
        keysIn.add("45994713-d3c3-40d6-87b5-6ce51f36001c");
        keysIn.add("901b15c5-799c-4387-8337-a1a35fceb791");
        keysIn.add("80fdae14-0e5d-4ea6-8eb8-50fde422056d");
        keysIn.add("e1996c33-c436-4004-9e3e-14de191bcc6b");
        keysIn.add("f715d9ff-d4eb-4073-92e8-2411cd5d0d68");
        Transaction txn = new Transaction();
        if (connection != null) {
            try {
                txn.begin(connection);
                FindBusinessByIdentifierQuery.select(identifierBag, keysIn, null, connection);
                FindBusinessByIdentifierQuery.select(identifierBag, null, null, connection);
                txn.commit();
            }
            catch (Exception ex) {
                try {
                    txn.rollback();
                }
                catch (SQLException sqlex) {
                    sqlex.printStackTrace();
                }
                throw ex;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        StringBuffer sql = new StringBuffer(200);
        sql.append("SELECT B.BUSINESS_KEY,B.LAST_UPDATE ");
        sql.append("FROM BUSINESS_ENTITY B,BUSINESS_IDENTIFIER I ");
        selectSQL = sql.toString();
    }
}

