/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.datastore.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datatype.TModelBag;
import org.apache.juddi.datatype.TModelKey;
import org.apache.juddi.datatype.request.FindQualifiers;
import org.apache.juddi.util.Config;
import org.apache.juddi.util.jdbc.ConnectionManager;
import org.apache.juddi.util.jdbc.DynamicQuery;
import org.apache.juddi.util.jdbc.Transaction;

class FindBusinessByTModelKeyQuery {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$juddi$datastore$jdbc$FindBusinessByTModelKeyQuery == null ? (class$org$apache$juddi$datastore$jdbc$FindBusinessByTModelKeyQuery = FindBusinessByTModelKeyQuery.class$("org.apache.juddi.datastore.jdbc.FindBusinessByTModelKeyQuery")) : class$org$apache$juddi$datastore$jdbc$FindBusinessByTModelKeyQuery));
    static String selectSQL;
    static /* synthetic */ Class class$org$apache$juddi$datastore$jdbc$FindBusinessByTModelKeyQuery;

    FindBusinessByTModelKeyQuery() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector select(TModelBag tModelBag, Vector keysIn, FindQualifiers qualifiers, Connection connection) throws SQLException {
        Vector<String> vector;
        if (keysIn != null && keysIn.size() == 0) {
            return keysIn;
        }
        Vector<String> keysOut = new Vector<String>();
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        DynamicQuery sql = new DynamicQuery(selectSQL);
        FindBusinessByTModelKeyQuery.appendWhere(sql, tModelBag, qualifiers);
        FindBusinessByTModelKeyQuery.appendIn(sql, keysIn);
        FindBusinessByTModelKeyQuery.appendOrderBy(sql, qualifiers);
        try {
            log.debug((Object)sql.toString());
            statement = sql.buildPreparedStatement(connection);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                keysOut.addElement(resultSet.getString(1));
            }
            vector = keysOut;
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            try {
                resultSet.close();
            }
            catch (Exception e) {
                log.warn((Object)("An Exception was encountered while attempting to close the Find BusinessEntity ResultSet: " + e.getMessage()), (Throwable)e);
            }
            try {
                statement.close();
            }
            catch (Exception e) {
                log.warn((Object)("An Exception was encountered while attempting to close the Find BusinessEntity Statement: " + e.getMessage()), (Throwable)e);
            }
            throw throwable;
        }
        try {
            resultSet.close();
        }
        catch (Exception e) {
            log.warn((Object)("An Exception was encountered while attempting to close the Find BusinessEntity ResultSet: " + e.getMessage()), (Throwable)e);
        }
        try {
            statement.close();
        }
        catch (Exception e) {
            log.warn((Object)("An Exception was encountered while attempting to close the Find BusinessEntity Statement: " + e.getMessage()), (Throwable)e);
        }
        return vector;
    }

    private static void appendWhere(DynamicQuery sql, TModelBag tModelBag, FindQualifiers qualifiers) {
        sql.append("WHERE I.BINDING_KEY = T.BINDING_KEY ");
        sql.append("AND T.SERVICE_KEY = S.SERVICE_KEY ");
        sql.append("AND S.BUSINESS_KEY = B.BUSINESS_KEY ");
        Vector keyVector = tModelBag.getTModelKeyVector();
        int vectorSize = keyVector.size();
        if (vectorSize > 0) {
            sql.append("AND (");
            for (int i = 0; i < vectorSize; ++i) {
                String key = (String)keyVector.elementAt(i);
                sql.append("I.TMODEL_KEY = ? ");
                sql.addValue(key);
                if (i + 1 >= vectorSize) continue;
                sql.append(" OR ");
            }
            sql.append(") ");
        }
    }

    private static void appendIn(DynamicQuery sql, Vector keysIn) {
        if (keysIn == null) {
            return;
        }
        sql.append("AND B.BUSINESS_KEY IN (");
        int keyCount = keysIn.size();
        for (int i = 0; i < keyCount; ++i) {
            String key = (String)keysIn.elementAt(i);
            sql.append("?");
            sql.addValue(key);
            if (i + 1 >= keyCount) continue;
            sql.append(",");
        }
        sql.append(") ");
    }

    private static void appendOrderBy(DynamicQuery sql, FindQualifiers qualifiers) {
        sql.append("ORDER BY ");
        if (qualifiers == null) {
            sql.append("B.LAST_UPDATE DESC");
        } else if (qualifiers.sortByDateAsc) {
            sql.append("B.LAST_UPDATE ASC");
        } else {
            sql.append("B.LAST_UPDATE DESC");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Config.setStringProperty("juddi.useConnectionPool", "true");
        Connection conn = null;
        try {
            conn = ConnectionManager.aquireConnection();
            FindBusinessByTModelKeyQuery.test(conn);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    public static void test(Connection connection) throws Exception {
        TModelBag tModelBag = new TModelBag();
        Vector<TModelKey> tModelKeyVector = new Vector<TModelKey>();
        tModelKeyVector.addElement(new TModelKey(""));
        tModelKeyVector.addElement(new TModelKey(""));
        tModelKeyVector.addElement(new TModelKey("2a33d7d7-2b73-4de9-99cd-d4c51c186bce"));
        tModelKeyVector.addElement(new TModelKey("2a33d7d7-2b73-4de9-99cd-d4c51c186bce"));
        tModelBag.setTModelKeyVector(tModelKeyVector);
        Vector<String> keysIn = new Vector<String>();
        keysIn.add("13411e97-24cf-43d1-bee0-455e7ec5e9fc");
        keysIn.add("3f244f19-7ba7-4c3e-a93e-ae33e530794b");
        keysIn.add("3009f336-98c1-4193-a22f-fea73e79c909");
        keysIn.add("3ef4772f-e04b-46ed-8065-c5a4e167b5ba");
        Transaction txn = new Transaction();
        if (connection != null) {
            try {
                txn.begin(connection);
                FindBusinessByTModelKeyQuery.select(tModelBag, keysIn, null, connection);
                FindBusinessByTModelKeyQuery.select(tModelBag, null, null, connection);
                txn.commit();
            }
            catch (Exception ex) {
                try {
                    txn.rollback();
                }
                catch (SQLException sqlex) {
                    sqlex.printStackTrace();
                }
                throw ex;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        StringBuffer sql = new StringBuffer(200);
        sql.append("SELECT B.BUSINESS_KEY,B.LAST_UPDATE ");
        sql.append("FROM BUSINESS_ENTITY B,BUSINESS_SERVICE S,BINDING_TEMPLATE T,TMODEL_INSTANCE_INFO I ");
        selectSQL = sql.toString();
    }
}

