/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.datastore.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datatype.request.FindQualifiers;
import org.apache.juddi.util.Config;
import org.apache.juddi.util.jdbc.ConnectionManager;
import org.apache.juddi.util.jdbc.DynamicQuery;
import org.apache.juddi.util.jdbc.Transaction;

class FindPublisherByNameQuery {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$juddi$datastore$jdbc$FindPublisherByNameQuery == null ? (class$org$apache$juddi$datastore$jdbc$FindPublisherByNameQuery = FindPublisherByNameQuery.class$("org.apache.juddi.datastore.jdbc.FindPublisherByNameQuery")) : class$org$apache$juddi$datastore$jdbc$FindPublisherByNameQuery));
    static String selectSQL;
    static /* synthetic */ Class class$org$apache$juddi$datastore$jdbc$FindPublisherByNameQuery;

    FindPublisherByNameQuery() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector select(String name, Vector idsIn, FindQualifiers qualifiers, Connection connection) throws SQLException {
        Vector<String> vector;
        if (idsIn != null && idsIn.size() == 0) {
            return idsIn;
        }
        Vector<String> idsOut = new Vector<String>();
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        DynamicQuery sql = new DynamicQuery(selectSQL);
        FindPublisherByNameQuery.appendWhere(sql, name, qualifiers);
        FindPublisherByNameQuery.appendIn(sql, name, idsIn);
        FindPublisherByNameQuery.appendOrderBy(sql, qualifiers);
        try {
            log.debug((Object)sql.toString());
            statement = sql.buildPreparedStatement(connection);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                idsOut.addElement(resultSet.getString(1));
            }
            vector = idsOut;
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            try {
                resultSet.close();
            }
            catch (Exception e) {
                log.warn((Object)("An Exception was encountered while attempting to close the Find Publisher ResultSet: " + e.getMessage()), (Throwable)e);
            }
            try {
                statement.close();
            }
            catch (Exception e) {
                log.warn((Object)("An Exception was encountered while attempting to close the Find Publisher Statement: " + e.getMessage()), (Throwable)e);
            }
            throw throwable;
        }
        try {
            resultSet.close();
        }
        catch (Exception e) {
            log.warn((Object)("An Exception was encountered while attempting to close the Find Publisher ResultSet: " + e.getMessage()), (Throwable)e);
        }
        try {
            statement.close();
        }
        catch (Exception e) {
            log.warn((Object)("An Exception was encountered while attempting to close the Find Publisher Statement: " + e.getMessage()), (Throwable)e);
        }
        return vector;
    }

    private static void appendWhere(DynamicQuery sql, String name, FindQualifiers qualifiers) {
        if (name == null || name.length() == 0) {
            return;
        }
        if (qualifiers != null && qualifiers.exactNameMatch) {
            sql.append("WHERE P.PUBLISHER_NAME = ? ");
            sql.addValue(name);
        } else {
            sql.append("WHERE P.PUBLISHER_NAME LIKE ? ");
            sql.addValue(name + "%");
        }
    }

    private static void appendIn(DynamicQuery sql, String name, Vector keysIn) {
        if (keysIn == null) {
            return;
        }
        if (name == null || name.length() == 0) {
            sql.append("WHERE P.PUBLISHER_ID IN (");
        } else {
            sql.append("AND P.PUBLISHER_ID IN (");
        }
        int keyCount = keysIn.size();
        for (int i = 0; i < keyCount; ++i) {
            String key = (String)keysIn.elementAt(i);
            sql.append("?");
            sql.addValue(key);
            if (i + 1 >= keyCount) continue;
            sql.append(",");
        }
        sql.append(") ");
    }

    private static void appendOrderBy(DynamicQuery sql, FindQualifiers qualifiers) {
        sql.append("ORDER BY ");
        if (qualifiers == null || qualifiers.sortByNameDesc || !qualifiers.sortByNameAsc && !qualifiers.sortByNameDesc) {
            sql.append("P.PUBLISHER_NAME DESC");
        } else if (qualifiers.sortByNameAsc) {
            sql.append("P.PUBLISHER_NAME ASC");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Config.setStringProperty("juddi.useConnectionPool", "true");
        Connection conn = null;
        try {
            conn = ConnectionManager.aquireConnection();
            FindPublisherByNameQuery.test(conn);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    public static void test(Connection connection) throws Exception {
        String name = new String("Steve");
        Vector<String> idsIn = null;
        idsIn = new Vector<String>();
        idsIn.add(new String("sviens"));
        idsIn.add(new String("jdoe"));
        idsIn.add(new String("steveviens"));
        Transaction txn = new Transaction();
        if (connection != null) {
            try {
                txn.begin(connection);
                Vector results = FindPublisherByNameQuery.select(name, idsIn, null, connection);
                if (results != null) {
                    for (int i = 0; i < results.size(); ++i) {
                        System.out.println(i + ": " + (String)results.elementAt(i));
                    }
                }
                FindQualifiers fqs = new FindQualifiers();
                fqs.sortByNameAsc = true;
                Vector resutls2 = FindPublisherByNameQuery.select(name, null, fqs, connection);
                if (results != null) {
                    for (int i = 0; i < resutls2.size(); ++i) {
                        System.out.println(i + ": " + (String)resutls2.elementAt(i));
                    }
                }
                fqs.exactNameMatch = true;
                Vector resutls3 = FindPublisherByNameQuery.select(name, null, fqs, connection);
                if (results != null) {
                    for (int i = 0; i < resutls3.size(); ++i) {
                        System.out.println(i + ": " + (String)resutls3.elementAt(i));
                    }
                }
                txn.commit();
            }
            catch (Exception ex) {
                try {
                    txn.rollback();
                }
                catch (SQLException sqlex) {
                    sqlex.printStackTrace();
                }
                throw ex;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        StringBuffer sql = new StringBuffer(200);
        sql.append("SELECT P.PUBLISHER_ID,P.PUBLISHER_NAME ");
        sql.append("FROM PUBLISHER P ");
        selectSQL = sql.toString();
    }
}

