/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.datastore.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datatype.Name;
import org.apache.juddi.datatype.request.FindQualifiers;
import org.apache.juddi.util.Config;
import org.apache.juddi.util.jdbc.ConnectionManager;
import org.apache.juddi.util.jdbc.DynamicQuery;
import org.apache.juddi.util.jdbc.Transaction;

class FindServiceByNameQuery {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$juddi$datastore$jdbc$FindServiceByNameQuery == null ? (class$org$apache$juddi$datastore$jdbc$FindServiceByNameQuery = FindServiceByNameQuery.class$("org.apache.juddi.datastore.jdbc.FindServiceByNameQuery")) : class$org$apache$juddi$datastore$jdbc$FindServiceByNameQuery));
    static String selectSQL;
    static /* synthetic */ Class class$org$apache$juddi$datastore$jdbc$FindServiceByNameQuery;

    FindServiceByNameQuery() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector select(String businessKey, Vector names, Vector keysIn, FindQualifiers qualifiers, Connection connection) throws SQLException {
        Vector<String> vector;
        if (keysIn != null && keysIn.size() == 0) {
            return keysIn;
        }
        Vector<String> keysOut = new Vector<String>();
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        DynamicQuery sql = new DynamicQuery(selectSQL);
        FindServiceByNameQuery.appendWhere(sql, businessKey, names, qualifiers);
        FindServiceByNameQuery.appendIn(sql, keysIn);
        FindServiceByNameQuery.appendOrderBy(sql, qualifiers);
        try {
            log.debug((Object)sql.toString());
            statement = sql.buildPreparedStatement(connection);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                keysOut.addElement(resultSet.getString(1));
            }
            vector = keysOut;
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            try {
                resultSet.close();
            }
            catch (Exception e) {
                log.warn((Object)("An Exception was encountered while attempting to close the Find BusinessService ResultSet: " + e.getMessage()), (Throwable)e);
            }
            try {
                statement.close();
            }
            catch (Exception e) {
                log.warn((Object)("An Exception was encountered while attempting to close the Find BusinessService Statement: " + e.getMessage()), (Throwable)e);
            }
            throw throwable;
        }
        try {
            resultSet.close();
        }
        catch (Exception e) {
            log.warn((Object)("An Exception was encountered while attempting to close the Find BusinessService ResultSet: " + e.getMessage()), (Throwable)e);
        }
        try {
            statement.close();
        }
        catch (Exception e) {
            log.warn((Object)("An Exception was encountered while attempting to close the Find BusinessService Statement: " + e.getMessage()), (Throwable)e);
        }
        return vector;
    }

    private static void appendWhere(DynamicQuery sql, String businessKey, Vector names, FindQualifiers qualifiers) {
        sql.append("WHERE N.SERVICE_KEY = S.SERVICE_KEY ");
        if (businessKey != null && businessKey.length() > 0) {
            sql.append("AND S.BUSINESS_KEY = ? ");
            sql.addValue(businessKey);
        }
        if (names != null && names.size() > 0) {
            sql.append("AND (");
            int nameSize = names.size();
            for (int i = 0; i < nameSize; ++i) {
                Name name = (Name)names.elementAt(i);
                String text = name.getValue();
                String lang = name.getLanguageCode();
                if (text == null || text.length() <= 0) continue;
                if (qualifiers != null && qualifiers.exactNameMatch) {
                    sql.append("(NAME = ?");
                    sql.addValue(text);
                } else {
                    sql.append("(NAME LIKE ?");
                    sql.addValue(text.endsWith("%") ? text : text + "%");
                }
                if (lang != null && lang.length() > 0) {
                    sql.append(" AND LANG_CODE = ?");
                    sql.addValue(lang);
                }
                sql.append(")");
                if (i + 1 >= nameSize) continue;
                sql.append(" OR ");
            }
            sql.append(") ");
        }
    }

    private static void appendIn(DynamicQuery sql, Vector keysIn) {
        if (keysIn == null) {
            return;
        }
        sql.append("AND S.SERVICE_KEY IN (");
        int keyCount = keysIn.size();
        for (int i = 0; i < keyCount; ++i) {
            String key = (String)keysIn.elementAt(i);
            sql.append("?");
            sql.addValue(key);
            if (i + 1 >= keyCount) continue;
            sql.append(",");
        }
        sql.append(") ");
    }

    private static void appendOrderBy(DynamicQuery sql, FindQualifiers qualifiers) {
        sql.append("ORDER BY ");
        if (qualifiers == null || !qualifiers.sortByNameAsc && !qualifiers.sortByNameDesc && !qualifiers.sortByDateAsc && !qualifiers.sortByDateDesc) {
            sql.append("N.NAME ASC,S.LAST_UPDATE DESC");
        } else if (qualifiers.sortByNameAsc || qualifiers.sortByNameDesc) {
            if (qualifiers.sortByNameAsc && qualifiers.sortByDateDesc) {
                sql.append("N.NAME ASC,S.LAST_UPDATE DESC");
            } else if (qualifiers.sortByNameAsc && qualifiers.sortByDateAsc) {
                sql.append("N.NAME ASC,S.LAST_UPDATE ASC");
            } else if (qualifiers.sortByNameDesc && qualifiers.sortByDateDesc) {
                sql.append("N.NAME DESC,S.LAST_UPDATE DESC");
            } else {
                sql.append("N.NAME DESC,S.LAST_UPDATE ASC");
            }
        } else if (qualifiers.sortByDateAsc || qualifiers.sortByDateDesc) {
            if (qualifiers.sortByDateDesc) {
                sql.append("S.LAST_UPDATE ASC,N.NAME ASC");
            } else {
                sql.append("S.LAST_UPDATE DESC,N.NAME ASC");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Config.setStringProperty("juddi.useConnectionPool", "true");
        Connection conn = null;
        try {
            conn = ConnectionManager.aquireConnection();
            FindServiceByNameQuery.test(conn);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    public static void test(Connection connection) throws Exception {
        String businessKey = "0e70128c-f7c6-4854-b292-d2f13b638acf";
        Vector<Name> names = new Vector<Name>();
        names.add(new Name("St"));
        Vector<String> keysIn = null;
        keysIn = new Vector<String>();
        keysIn.add("0e70128c-f7c6-4854-b292-d2f13b638acf");
        keysIn.add("b405450a-64f5-4f95-8131-450429d0ae8c");
        keysIn.add("3009f336-98c1-4193-a22f-fea73e79c909");
        keysIn.add("45994713-d3c3-40d6-87b5-6ce51f36001c");
        keysIn.add("901b15c5-799c-4387-8337-a1a35fceb791");
        keysIn.add("80fdae14-0e5d-4ea6-8eb8-50fde422056d");
        keysIn.add("e1996c33-c436-4004-9e3e-14de191bcc6b");
        keysIn.add("3ef4772f-e04b-46ed-8065-c5a4e167b5ba");
        Transaction txn = new Transaction();
        if (connection != null) {
            try {
                txn.begin(connection);
                FindServiceByNameQuery.select(businessKey, names, keysIn, null, connection);
                FindServiceByNameQuery.select(businessKey, names, null, null, connection);
                txn.commit();
            }
            catch (Exception ex) {
                try {
                    txn.rollback();
                }
                catch (SQLException sqlex) {
                    sqlex.printStackTrace();
                }
                throw ex;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        StringBuffer sql = new StringBuffer(200);
        sql.append("SELECT S.SERVICE_KEY,S.LAST_UPDATE,N.NAME ");
        sql.append("FROM BUSINESS_SERVICE S,SERVICE_NAME N ");
        selectSQL = sql.toString();
    }
}

