/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.datastore.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datatype.publisher.Publisher;
import org.apache.juddi.util.Config;
import org.apache.juddi.util.jdbc.ConnectionManager;
import org.apache.juddi.util.jdbc.Transaction;

public class PublisherTable {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$juddi$datastore$jdbc$PublisherTable == null ? (class$org$apache$juddi$datastore$jdbc$PublisherTable = PublisherTable.class$("org.apache.juddi.datastore.jdbc.PublisherTable")) : class$org$apache$juddi$datastore$jdbc$PublisherTable));
    static String insertSQL = null;
    static String selectSQL = null;
    static String deleteSQL = null;
    static String updateSQL = null;
    static String verifyAdminSQL = null;
    static /* synthetic */ Class class$org$apache$juddi$datastore$jdbc$PublisherTable;

    public static void insert(Publisher publisher, Connection connection) throws SQLException {
        if (publisher == null) {
            return;
        }
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(insertSQL);
            statement.setString(1, publisher.getPublisherID());
            statement.setString(2, publisher.getName());
            statement.setString(3, publisher.getFirstName());
            statement.setString(4, publisher.getLastName());
            statement.setString(5, publisher.getMiddleInit());
            statement.setString(6, publisher.getWorkPhone());
            statement.setString(7, publisher.getMobilePhone());
            statement.setString(8, publisher.getPager());
            statement.setString(9, publisher.getEmailAddress());
            statement.setString(10, String.valueOf(publisher.isAdmin()));
            statement.setString(11, String.valueOf(publisher.isEnabled()));
            log.debug((Object)("insert into PUBLISHER table:\n\n\t" + insertSQL + "\n\t PUBLISHER_ID=" + publisher.getPublisherID() + "\n\t PUBLISHER_NAME=" + publisher.getName() + "\n\t FIRST_NAME=" + publisher.getFirstName() + "\n\t LAST_NAME=" + publisher.getLastName() + "\n\t MIDDLE_INIT=" + publisher.getMiddleInit() + "\n\t WORK_PHONE=" + publisher.getWorkPhone() + "\n\t MOBILE_PHONE=" + publisher.getMobilePhone() + "\n\t PAGER=" + publisher.getPager() + "\n\t EMAIL_ADDRESS=" + publisher.getEmailAddress() + "\n\t ADMIN=" + publisher.isAdmin() + "\n\t ENABLED=" + publisher.isEnabled() + "\n"));
            statement.executeUpdate();
        }
        catch (SQLException sqlex) {
            log.error((Object)sqlex.getMessage());
            throw sqlex;
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    public static Publisher select(String publisherID, Connection connection) throws SQLException {
        if (publisherID == null) {
            return null;
        }
        Publisher publisher = null;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.prepareStatement(selectSQL);
            statement.setString(1, publisherID);
            log.debug((Object)("select from PUBLISHER table:\n\n\t" + selectSQL + "\n\t PUBLISHER_ID=" + publisherID + "\n"));
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                publisher = new Publisher();
                publisher.setPublisherID(publisherID);
                publisher.setName(resultSet.getString(1));
                publisher.setLastName(resultSet.getString(2));
                publisher.setFirstName(resultSet.getString(3));
                publisher.setMiddleInit(resultSet.getString(4));
                publisher.setWorkPhone(resultSet.getString(5));
                publisher.setMobilePhone(resultSet.getString(6));
                publisher.setPager(resultSet.getString(7));
                publisher.setEmailAddress(resultSet.getString(8));
                publisher.setAdminValue(resultSet.getString(9));
                publisher.setEnabledValue(resultSet.getString(10));
            }
            Publisher publisher2 = publisher;
            return publisher2;
        }
        catch (SQLException sqlex) {
            log.error((Object)sqlex.getMessage());
            throw sqlex;
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception e) {}
            try {
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    public static void delete(String publisherID, Connection connection) throws SQLException {
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(deleteSQL);
            statement.setString(1, publisherID);
            log.debug((Object)("delete from PUBLISHER table:\n\n\t" + deleteSQL + "\n\t PUBLISHER_ID=" + "\n"));
            statement.executeUpdate();
        }
        catch (SQLException sqlex) {
            log.error((Object)sqlex.getMessage());
            throw sqlex;
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    public static void update(Publisher publisher, Connection connection) throws SQLException {
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(updateSQL);
            statement.setString(1, publisher.getName());
            statement.setString(2, publisher.getFirstName());
            statement.setString(3, publisher.getLastName());
            statement.setString(4, publisher.getMiddleInit());
            statement.setString(5, publisher.getWorkPhone());
            statement.setString(6, publisher.getMobilePhone());
            statement.setString(7, publisher.getPager());
            statement.setString(8, publisher.getEmailAddress());
            statement.setString(9, String.valueOf(publisher.isAdmin()));
            statement.setString(10, String.valueOf(publisher.isEnabled()));
            statement.setString(11, publisher.getPublisherID());
            log.debug((Object)("update PUBLISHER table:\n\n\t" + updateSQL + "\n\t PUBLISHER_NAME=" + publisher.getName() + "\n\t FIRST_NAME=" + publisher.getFirstName() + "\n\t LAST_NAME=" + publisher.getLastName() + "\n\t MIDDLE_INIT=" + publisher.getMiddleInit() + "\n\t WORK_PHONE=" + publisher.getWorkPhone() + "\n\t MOBILE_PHONE=" + publisher.getMobilePhone() + "\n\t PAGER=" + publisher.getPager() + "\n\t EMAIL_ADDRESS=" + publisher.getEmailAddress() + "\n\t ADMIN=" + publisher.isAdmin() + "\n\t ENABLED=" + publisher.isEnabled() + "\n\t PUBLISHER_ID=" + publisher.getPublisherID() + "\n"));
            statement.executeUpdate();
        }
        catch (SQLException sqlex) {
            log.error((Object)sqlex.getMessage());
            throw sqlex;
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Config.setStringProperty("juddi.useConnectionPool", "true");
        Connection conn = null;
        try {
            conn = ConnectionManager.aquireConnection();
            PublisherTable.test(conn);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    public static void test(Connection connection) throws Exception {
        Transaction txn = new Transaction();
        if (connection != null) {
            try {
                txn.begin(connection);
                Publisher publisher = new Publisher();
                publisher.setPublisherID("bcrosby");
                publisher.setName("Bing Crosby");
                publisher.setLastName("Crosby");
                publisher.setFirstName("Bing");
                publisher.setWorkPhone("978.123-4567");
                publisher.setMobilePhone("617-765-9876");
                publisher.setPager("800-123-4655 ID: 501");
                publisher.setEmailAddress("bcrosby@juddi.org");
                publisher.setAdmin(false);
                publisher.setEnabled(false);
                PublisherTable.insert(publisher, connection);
                System.out.println(PublisherTable.select("bcrosby", connection));
                publisher.setFirstName("Bart");
                publisher.setName("Barthalomue Crosby");
                publisher.setEnabled(true);
                PublisherTable.update(publisher, connection);
                System.out.println(PublisherTable.select("bcrosby", connection));
                PublisherTable.delete("bcrosby", connection);
                System.out.println(PublisherTable.select("bcrosby", connection));
                System.out.println("");
                txn.commit();
            }
            catch (Exception ex) {
                try {
                    txn.rollback();
                }
                catch (SQLException sqlex) {
                    sqlex.printStackTrace();
                }
                throw ex;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        StringBuffer sql = null;
        sql = new StringBuffer(150);
        sql.append("INSERT INTO PUBLISHER (");
        sql.append("PUBLISHER_ID,");
        sql.append("PUBLISHER_NAME,");
        sql.append("LAST_NAME,");
        sql.append("FIRST_NAME,");
        sql.append("MIDDLE_INIT,");
        sql.append("WORK_PHONE,");
        sql.append("MOBILE_PHONE,");
        sql.append("PAGER,");
        sql.append("EMAIL_ADDRESS,");
        sql.append("ADMIN, ");
        sql.append("ENABLED) ");
        sql.append("VALUES (?,?,?,?,?,?,?,?,?,?,?)");
        insertSQL = sql.toString();
        sql = new StringBuffer(200);
        sql.append("SELECT ");
        sql.append("PUBLISHER_NAME,");
        sql.append("LAST_NAME,");
        sql.append("FIRST_NAME,");
        sql.append("MIDDLE_INIT,");
        sql.append("WORK_PHONE,");
        sql.append("MOBILE_PHONE,");
        sql.append("PAGER,");
        sql.append("EMAIL_ADDRESS,");
        sql.append("ADMIN,");
        sql.append("ENABLED ");
        sql.append("FROM PUBLISHER ");
        sql.append("WHERE PUBLISHER_ID=?");
        selectSQL = sql.toString();
        sql = new StringBuffer(200);
        sql.append("DELETE FROM PUBLISHER ");
        sql.append("WHERE PUBLISHER_ID=?");
        deleteSQL = sql.toString();
        sql = new StringBuffer(200);
        sql.append("UPDATE PUBLISHER ");
        sql.append("SET PUBLISHER_NAME=?,");
        sql.append("LAST_NAME=?,");
        sql.append("FIRST_NAME=?,");
        sql.append("MIDDLE_INIT=?,");
        sql.append("WORK_PHONE=?,");
        sql.append("MOBILE_PHONE=?,");
        sql.append("PAGER=?,");
        sql.append("EMAIL_ADDRESS=?,");
        sql.append("ADMIN=?,");
        sql.append("ENABLED=? ");
        sql.append("WHERE PUBLISHER_ID=?");
        updateSQL = sql.toString();
    }
}

