/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.datastore.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datastore.jdbc.BusinessEntityTable;
import org.apache.juddi.datastore.jdbc.BusinessServiceTable;
import org.apache.juddi.datatype.Name;
import org.apache.juddi.datatype.business.BusinessEntity;
import org.apache.juddi.datatype.service.BusinessService;
import org.apache.juddi.util.Config;
import org.apache.juddi.util.jdbc.ConnectionManager;
import org.apache.juddi.util.jdbc.Transaction;
import org.apache.juddi.uuidgen.UUIDGen;
import org.apache.juddi.uuidgen.UUIDGenFactory;

class ServiceNameTable {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$juddi$datastore$jdbc$ServiceNameTable == null ? (class$org$apache$juddi$datastore$jdbc$ServiceNameTable = ServiceNameTable.class$("org.apache.juddi.datastore.jdbc.ServiceNameTable")) : class$org$apache$juddi$datastore$jdbc$ServiceNameTable));
    static String insertSQL = null;
    static String selectSQL = null;
    static String deleteSQL = null;
    static /* synthetic */ Class class$org$apache$juddi$datastore$jdbc$ServiceNameTable;

    ServiceNameTable() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insert(String serviceKey, Vector nameList, Connection connection) throws SQLException {
        if (nameList == null || nameList.size() == 0) {
            return;
        }
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(insertSQL);
            statement.setString(1, serviceKey.toString());
            int listSize = nameList.size();
            for (int nameID = 0; nameID < listSize; ++nameID) {
                Name name = (Name)nameList.elementAt(nameID);
                statement.setInt(2, nameID);
                statement.setString(3, name.getLanguageCode());
                statement.setString(4, name.getValue());
                log.debug((Object)("insert into SERVICE_NAME table:\n\n\t" + insertSQL + "\n\t SERVICE_KEY=" + serviceKey.toString() + "\n\t SERVICE_NAME_ID=" + nameID + "\n\t LANG_CODE=" + name.getLanguageCode() + "\n\t NAME=" + name.getValue() + "\n"));
                statement.executeUpdate();
            }
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector select(String serviceKey, Connection connection) throws SQLException {
        Vector<Name> nameList = new Vector<Name>();
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.prepareStatement(selectSQL);
            statement.setString(1, serviceKey.toString());
            log.debug((Object)("select from SERVICE_NAME table:\n\n\t" + selectSQL + "\n\t SERVICE_KEY=" + serviceKey.toString() + "\n"));
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                Name name = new Name();
                name.setLanguageCode(resultSet.getString(1));
                name.setValue(resultSet.getString(2));
                nameList.add(name);
            }
            Vector<Name> vector = nameList;
            return vector;
        }
        finally {
            try {
                statement.close();
                resultSet.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delete(String serviceKey, Connection connection) throws SQLException {
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(deleteSQL);
            statement.setString(1, serviceKey.toString());
            log.debug((Object)("delete from SERVICE_NAME table:\n\n\t" + deleteSQL + "\n\t SERVICE_KEY=" + serviceKey.toString() + "\n"));
            statement.executeUpdate();
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Config.setStringProperty("juddi.useConnectionPool", "true");
        Connection conn = null;
        try {
            conn = ConnectionManager.aquireConnection();
            ServiceNameTable.test(conn);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    public static void test(Connection connection) throws Exception {
        Transaction txn = new Transaction();
        UUIDGen uuidgen = UUIDGenFactory.getUUIDGen();
        if (connection != null) {
            try {
                String businessKey = uuidgen.uuidgen();
                BusinessEntity business = new BusinessEntity();
                business.setBusinessKey(businessKey);
                business.setAuthorizedName("sviens");
                business.setOperator("WebServiceRegistry.com");
                String serviceKey = uuidgen.uuidgen();
                BusinessService service = new BusinessService();
                service.setServiceKey(serviceKey);
                service.setBusinessKey(businessKey);
                Vector nameList = new Vector();
                nameList.add(new Name("SteveViens.com", "en"));
                nameList.add(new Name("EsephanoViens.com", "it"));
                nameList.add(new Name("AsdfJkl.com", "cy"));
                String authorizedUserID = "sviens";
                txn.begin(connection);
                BusinessEntityTable.insert(business, authorizedUserID, connection);
                BusinessServiceTable.insert(service, connection);
                ServiceNameTable.insert(serviceKey, nameList, connection);
                nameList = ServiceNameTable.select(serviceKey, connection);
                ServiceNameTable.delete(serviceKey, connection);
                nameList = ServiceNameTable.select(serviceKey, connection);
                txn.commit();
            }
            catch (Exception ex) {
                try {
                    txn.rollback();
                }
                catch (SQLException sqlex) {
                    sqlex.printStackTrace();
                }
                throw ex;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        StringBuffer sql = null;
        sql = new StringBuffer(150);
        sql.append("INSERT INTO SERVICE_NAME (");
        sql.append("SERVICE_KEY,");
        sql.append("SERVICE_NAME_ID,");
        sql.append("LANG_CODE,");
        sql.append("NAME) ");
        sql.append("VALUES (?,?,?,?)");
        insertSQL = sql.toString();
        sql = new StringBuffer(200);
        sql.append("SELECT ");
        sql.append("LANG_CODE,");
        sql.append("NAME, ");
        sql.append("SERVICE_NAME_ID ");
        sql.append("FROM SERVICE_NAME ");
        sql.append("WHERE SERVICE_KEY=? ");
        sql.append("ORDER BY SERVICE_NAME_ID");
        selectSQL = sql.toString();
        sql = new StringBuffer(100);
        sql.append("DELETE FROM SERVICE_NAME ");
        sql.append("WHERE SERVICE_KEY=?");
        deleteSQL = sql.toString();
    }
}

