/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.datastore.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datastore.jdbc.TModelTable;
import org.apache.juddi.datatype.Description;
import org.apache.juddi.datatype.OverviewDoc;
import org.apache.juddi.datatype.tmodel.TModel;
import org.apache.juddi.util.Config;
import org.apache.juddi.util.jdbc.ConnectionManager;
import org.apache.juddi.util.jdbc.Transaction;
import org.apache.juddi.uuidgen.UUIDGen;
import org.apache.juddi.uuidgen.UUIDGenFactory;

class TModelDescTable {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$juddi$datastore$jdbc$TModelDescTable == null ? (class$org$apache$juddi$datastore$jdbc$TModelDescTable = TModelDescTable.class$("org.apache.juddi.datastore.jdbc.TModelDescTable")) : class$org$apache$juddi$datastore$jdbc$TModelDescTable));
    static String insertSQL = null;
    static String selectSQL = null;
    static String deleteSQL = null;
    static /* synthetic */ Class class$org$apache$juddi$datastore$jdbc$TModelDescTable;

    TModelDescTable() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insert(String tModelKey, Vector descList, Connection connection) throws SQLException {
        if (descList == null || descList.size() == 0) {
            return;
        }
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(insertSQL);
            statement.setString(1, tModelKey.toString());
            int listSize = descList.size();
            for (int descID = 0; descID < listSize; ++descID) {
                Description desc = (Description)descList.elementAt(descID);
                statement.setInt(2, descID);
                statement.setString(3, desc.getLanguageCode());
                statement.setString(4, desc.getValue());
                log.debug((Object)("insert into TMODEL_DESCR table:\n\n\t" + insertSQL + "\n\t TMODEL_KEY=" + tModelKey.toString() + "\n\t TMODEL_DESCR_ID=" + descID + "\n\t LANG_CODE=" + desc.getLanguageCode() + "\n\t DESCR=" + desc.getValue() + "\n"));
                statement.executeUpdate();
            }
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector select(String tModelKey, Connection connection) throws SQLException {
        Vector<Description> descList = new Vector<Description>();
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.prepareStatement(selectSQL);
            statement.setString(1, tModelKey.toString());
            log.debug((Object)("select from TMODEL_DESCR table:\n\n\t" + selectSQL + "\n\t TMODEL_KEY=" + tModelKey.toString() + "\n"));
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                Description desc = new Description();
                desc.setLanguageCode(resultSet.getString(1));
                desc.setValue(resultSet.getString(2));
                descList.add(desc);
            }
            Vector<Description> vector = descList;
            return vector;
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delete(String tModelKey, Connection connection) throws SQLException {
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(deleteSQL);
            statement.setString(1, tModelKey.toString());
            log.debug((Object)("delete from TMODEL_DESCR table:\n\n\t" + deleteSQL + "\n\t TMODEL_KEY=" + tModelKey.toString() + "\n"));
            statement.executeUpdate();
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Config.setStringProperty("juddi.useConnectionPool", "true");
        Connection conn = null;
        try {
            conn = ConnectionManager.aquireConnection();
            TModelDescTable.test(conn);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    public static void test(Connection connection) throws Exception {
        Transaction txn = new Transaction();
        UUIDGen uuidgen = UUIDGenFactory.getUUIDGen();
        if (connection != null) {
            try {
                OverviewDoc overviewDoc = new OverviewDoc();
                overviewDoc.setOverviewURL("http://www.steveviens.com/overviewdoc.html");
                String tModelKey = uuidgen.uuidgen();
                TModel tModel = new TModel();
                tModel.setTModelKey(tModelKey);
                tModel.setAuthorizedName("sviens");
                tModel.setOperator("WebServiceRegistry.com");
                tModel.setName("Tuscany Web Service Company");
                tModel.setOverviewDoc(overviewDoc);
                Vector descList = new Vector();
                descList.add(new Description("blah, blah, blah", "en"));
                descList.add(new Description("Yadda, Yadda, Yadda", "it"));
                descList.add(new Description("WhoobWhoobWhoobWhoob", "cy"));
                descList.add(new Description("Haachachachacha", "km"));
                String authorizedUserID = "sviens";
                txn.begin(connection);
                TModelTable.insert(tModel, authorizedUserID, connection);
                TModelDescTable.insert(tModelKey, descList, connection);
                descList = TModelDescTable.select(tModelKey, connection);
                TModelDescTable.delete(tModelKey, connection);
                descList = TModelDescTable.select(tModelKey, connection);
                txn.commit();
            }
            catch (Exception ex) {
                try {
                    txn.rollback();
                }
                catch (SQLException sqlex) {
                    sqlex.printStackTrace();
                }
                throw ex;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        StringBuffer sql = null;
        sql = new StringBuffer(150);
        sql.append("INSERT INTO TMODEL_DESCR (");
        sql.append("TMODEL_KEY,");
        sql.append("TMODEL_DESCR_ID,");
        sql.append("LANG_CODE,");
        sql.append("DESCR) ");
        sql.append("VALUES (?,?,?,?)");
        insertSQL = sql.toString();
        sql = new StringBuffer(200);
        sql.append("SELECT ");
        sql.append("LANG_CODE,");
        sql.append("DESCR, ");
        sql.append("TMODEL_DESCR_ID ");
        sql.append("FROM TMODEL_DESCR ");
        sql.append("WHERE TMODEL_KEY=? ");
        sql.append("ORDER BY TMODEL_DESCR_ID");
        selectSQL = sql.toString();
        sql = new StringBuffer(100);
        sql.append("DELETE FROM TMODEL_DESCR ");
        sql.append("WHERE TMODEL_KEY=?");
        deleteSQL = sql.toString();
    }
}

