/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.function;

import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datastore.DataStore;
import org.apache.juddi.datastore.DataStoreFactory;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.publisher.Publisher;
import org.apache.juddi.datatype.request.AuthInfo;
import org.apache.juddi.datatype.request.DeleteBusiness;
import org.apache.juddi.datatype.response.DispositionReport;
import org.apache.juddi.datatype.response.Result;
import org.apache.juddi.error.InvalidKeyPassedException;
import org.apache.juddi.error.RegistryException;
import org.apache.juddi.error.UserMismatchException;
import org.apache.juddi.function.AbstractFunction;
import org.apache.juddi.registry.RegistryEngine;
import org.apache.juddi.util.Config;

public class DeleteBusinessFunction
extends AbstractFunction {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$juddi$function$DeleteBusinessFunction == null ? (class$org$apache$juddi$function$DeleteBusinessFunction = DeleteBusinessFunction.class$("org.apache.juddi.function.DeleteBusinessFunction")) : class$org$apache$juddi$function$DeleteBusinessFunction));
    static /* synthetic */ Class class$org$apache$juddi$function$DeleteBusinessFunction;

    public DeleteBusinessFunction(RegistryEngine registry) {
        super(registry);
    }

    public RegistryObject execute(RegistryObject regObject) throws RegistryException {
        DeleteBusiness request = (DeleteBusiness)regObject;
        String generic = request.getGeneric();
        AuthInfo authInfo = request.getAuthInfo();
        Vector businessKeyVector = request.getBusinessKeyVector();
        DataStore dataStore = DataStoreFactory.getDataStore();
        try {
            String businessKey;
            int i;
            dataStore.beginTrans();
            Publisher publisher = this.getPublisher(authInfo, dataStore);
            String publisherID = publisher.getPublisherID();
            for (i = 0; i < businessKeyVector.size(); ++i) {
                businessKey = (String)businessKeyVector.elementAt(i);
                if (!dataStore.isValidBusinessKey(businessKey)) {
                    throw new InvalidKeyPassedException(businessKey);
                }
                if (dataStore.isBusinessPublisher(businessKey, publisherID)) continue;
                throw new UserMismatchException(businessKey);
            }
            for (i = 0; i < businessKeyVector.size(); ++i) {
                businessKey = (String)businessKeyVector.elementAt(i);
                dataStore.deleteBusiness(businessKey);
                log.info((Object)("Publisher '" + publisherID + "' deleted BusinessEntity with key: " + businessKey));
            }
            dataStore.commit();
        }
        catch (InvalidKeyPassedException keyex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.info((Object)keyex.getMessage());
            throw keyex;
        }
        catch (UserMismatchException umex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.info((Object)umex.getMessage());
            throw umex;
        }
        catch (RegistryException regex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.error((Object)regex);
            throw regex;
        }
        catch (Exception ex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.error((Object)ex);
            throw new RegistryException(ex);
        }
        finally {
            if (dataStore != null) {
                dataStore.release();
            }
        }
        DispositionReport dispRpt = new DispositionReport();
        dispRpt.setGeneric(generic);
        dispRpt.setOperator(Config.getOperator());
        dispRpt.addResult(new Result(0));
        return dispRpt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        RegistryEngine reg = new RegistryEngine();
        reg.init();
        try {
            DeleteBusiness request = new DeleteBusiness();
            DispositionReport response = (DispositionReport)reg.execute(request);
            System.out.println("errno: " + response.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            reg.dispose();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

