/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.function;

import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datastore.DataStore;
import org.apache.juddi.datastore.DataStoreFactory;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.publisher.Publisher;
import org.apache.juddi.datatype.request.AuthInfo;
import org.apache.juddi.datatype.request.DeleteService;
import org.apache.juddi.datatype.response.DispositionReport;
import org.apache.juddi.datatype.response.Result;
import org.apache.juddi.error.InvalidKeyPassedException;
import org.apache.juddi.error.RegistryException;
import org.apache.juddi.error.UserMismatchException;
import org.apache.juddi.function.AbstractFunction;
import org.apache.juddi.registry.RegistryEngine;
import org.apache.juddi.util.Config;

public class DeleteServiceFunction
extends AbstractFunction {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$juddi$function$DeleteServiceFunction == null ? (class$org$apache$juddi$function$DeleteServiceFunction = DeleteServiceFunction.class$("org.apache.juddi.function.DeleteServiceFunction")) : class$org$apache$juddi$function$DeleteServiceFunction));
    static /* synthetic */ Class class$org$apache$juddi$function$DeleteServiceFunction;

    public DeleteServiceFunction(RegistryEngine registry) {
        super(registry);
    }

    public RegistryObject execute(RegistryObject regObject) throws RegistryException {
        DeleteService request = (DeleteService)regObject;
        String generic = request.getGeneric();
        AuthInfo authInfo = request.getAuthInfo();
        Vector serviceKeyVector = request.getServiceKeyVector();
        DataStore dataStore = DataStoreFactory.getDataStore();
        try {
            String serviceKey;
            int i;
            dataStore.beginTrans();
            Publisher publisher = this.getPublisher(authInfo, dataStore);
            String publisherID = publisher.getPublisherID();
            for (i = 0; i < serviceKeyVector.size(); ++i) {
                serviceKey = (String)serviceKeyVector.elementAt(i);
                if (serviceKey == null || serviceKey.length() == 0 || !dataStore.isValidServiceKey(serviceKey)) {
                    throw new InvalidKeyPassedException(serviceKey);
                }
                if (dataStore.isServicePublisher(serviceKey, publisherID)) continue;
                throw new UserMismatchException("serviceKey=" + serviceKey);
            }
            for (i = 0; i < serviceKeyVector.size(); ++i) {
                serviceKey = (String)serviceKeyVector.elementAt(i);
                dataStore.deleteService(serviceKey);
                log.info((Object)("Publisher '" + publisherID + "' deleted BusinessService with key: " + serviceKey));
            }
            dataStore.commit();
        }
        catch (InvalidKeyPassedException keyex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.info((Object)keyex.getMessage());
            throw keyex;
        }
        catch (UserMismatchException umex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.info((Object)umex.getMessage());
            throw umex;
        }
        catch (RegistryException regex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.error((Object)regex);
            throw regex;
        }
        catch (Exception ex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.error((Object)ex);
            throw new RegistryException(ex);
        }
        finally {
            if (dataStore != null) {
                dataStore.release();
            }
        }
        DispositionReport dispRpt = new DispositionReport();
        dispRpt.setGeneric(generic);
        dispRpt.setOperator(Config.getOperator());
        dispRpt.addResult(new Result(0));
        return dispRpt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        RegistryEngine reg = new RegistryEngine();
        reg.init();
        try {
            DeleteService request = new DeleteService();
            DispositionReport response = (DispositionReport)new DeleteServiceFunction(reg).execute(request);
            System.out.println("errno: " + response.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            reg.dispose();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

