/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.function;

import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datastore.DataStore;
import org.apache.juddi.datastore.DataStoreFactory;
import org.apache.juddi.datatype.CategoryBag;
import org.apache.juddi.datatype.Description;
import org.apache.juddi.datatype.KeyedReference;
import org.apache.juddi.datatype.Name;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.business.BusinessEntity;
import org.apache.juddi.datatype.publisher.Publisher;
import org.apache.juddi.datatype.request.AuthInfo;
import org.apache.juddi.datatype.request.GetAuthToken;
import org.apache.juddi.datatype.request.SaveBusiness;
import org.apache.juddi.datatype.request.SaveService;
import org.apache.juddi.datatype.response.AuthToken;
import org.apache.juddi.datatype.response.BusinessDetail;
import org.apache.juddi.datatype.response.ServiceDetail;
import org.apache.juddi.datatype.service.BusinessService;
import org.apache.juddi.datatype.service.BusinessServices;
import org.apache.juddi.error.InvalidKeyPassedException;
import org.apache.juddi.error.RegistryException;
import org.apache.juddi.error.UserMismatchException;
import org.apache.juddi.function.AbstractFunction;
import org.apache.juddi.registry.RegistryEngine;
import org.apache.juddi.util.Config;
import org.apache.juddi.uuidgen.UUIDGen;
import org.apache.juddi.uuidgen.UUIDGenFactory;

public class SaveServiceFunction
extends AbstractFunction {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$juddi$function$SaveServiceFunction == null ? (class$org$apache$juddi$function$SaveServiceFunction = SaveServiceFunction.class$("org.apache.juddi.function.SaveServiceFunction")) : class$org$apache$juddi$function$SaveServiceFunction));
    static /* synthetic */ Class class$org$apache$juddi$function$SaveServiceFunction;

    public SaveServiceFunction(RegistryEngine registry) {
        super(registry);
    }

    public RegistryObject execute(RegistryObject regObject) throws RegistryException {
        SaveService request = (SaveService)regObject;
        String generic = request.getGeneric();
        AuthInfo authInfo = request.getAuthInfo();
        Vector serviceVector = request.getBusinessServiceVector();
        UUIDGen uuidgen = UUIDGenFactory.getUUIDGen();
        DataStore dataStore = DataStoreFactory.getDataStore();
        try {
            BusinessService service;
            int i;
            dataStore.beginTrans();
            Publisher publisher = this.getPublisher(authInfo, dataStore);
            String publisherID = publisher.getPublisherID();
            for (i = 0; i < serviceVector.size(); ++i) {
                int vectorSize;
                Vector keyedRefVector;
                service = (BusinessService)serviceVector.elementAt(i);
                String businessKey = service.getBusinessKey();
                String serviceKey = service.getServiceKey();
                if (businessKey == null || businessKey.length() == 0 || !dataStore.isValidBusinessKey(businessKey)) {
                    throw new InvalidKeyPassedException("businessKey=" + businessKey);
                }
                if (!dataStore.isBusinessPublisher(businessKey, publisherID)) {
                    throw new UserMismatchException("businessKey=" + serviceKey);
                }
                if (serviceKey != null && serviceKey.length() > 0 && !dataStore.isValidServiceKey(serviceKey)) {
                    throw new InvalidKeyPassedException("serviceKey=" + serviceKey);
                }
                CategoryBag categoryBag = service.getCategoryBag();
                if (categoryBag == null || (keyedRefVector = categoryBag.getKeyedReferenceVector()) == null || (vectorSize = keyedRefVector.size()) <= 0) continue;
                for (int j = 0; j < vectorSize; ++j) {
                    KeyedReference keyedRef = (KeyedReference)keyedRefVector.elementAt(j);
                    String key = keyedRef.getTModelKey();
                    if (key != null && key.trim().length() != 0) continue;
                    keyedRef.setTModelKey("UUID:A035A07C-F362-44dd-8F95-E2B134BF43B4");
                }
            }
            for (i = 0; i < serviceVector.size(); ++i) {
                service = (BusinessService)serviceVector.elementAt(i);
                String serviceKey = service.getServiceKey();
                if (serviceKey != null && serviceKey.length() > 0) {
                    dataStore.deleteService(serviceKey);
                } else {
                    service.setServiceKey(uuidgen.uuidgen());
                }
                dataStore.saveService(service);
            }
            dataStore.commit();
            ServiceDetail detail = new ServiceDetail();
            detail.setGeneric(generic);
            detail.setOperator(Config.getOperator());
            detail.setTruncated(false);
            detail.setBusinessServiceVector(serviceVector);
            ServiceDetail serviceDetail = detail;
            return serviceDetail;
        }
        catch (InvalidKeyPassedException ikpex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.info((Object)ikpex);
            throw ikpex;
        }
        catch (UserMismatchException umex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.info((Object)umex);
            throw umex;
        }
        catch (RegistryException regex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.error((Object)regex);
            throw regex;
        }
        catch (Exception ex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.error((Object)ex);
            throw new RegistryException(ex);
        }
        finally {
            if (dataStore != null) {
                dataStore.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        RegistryEngine reg = new RegistryEngine();
        reg.init();
        try {
            GetAuthToken authTokenRequest = new GetAuthToken("sviens", "password");
            AuthToken authToken = (AuthToken)reg.execute(authTokenRequest);
            AuthInfo authInfo = authToken.getAuthInfo();
            Vector<Name> nameVector = new Vector<Name>();
            nameVector.add(new Name("Dow Chemical"));
            BusinessService service = new BusinessService();
            service.addName(new Name("Reaction Finder"));
            service.addDescription(new Description("Finds side effects when combining chemicals"));
            BusinessServices services = new BusinessServices();
            services.addBusinessService(service);
            BusinessEntity businessEntity = new BusinessEntity();
            businessEntity.setBusinessKey(null);
            businessEntity.setNameVector(nameVector);
            businessEntity.setBusinessServices(services);
            Vector<BusinessEntity> businessEntityVector = new Vector<BusinessEntity>();
            businessEntityVector.add(businessEntity);
            SaveBusiness request = new SaveBusiness();
            request.setAuthInfo(authInfo);
            request.setBusinessEntityVector(businessEntityVector);
            BusinessDetail detail = (BusinessDetail)reg.execute(request);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            reg.dispose();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

