/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.function;

import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datastore.DataStore;
import org.apache.juddi.datastore.DataStoreFactory;
import org.apache.juddi.datatype.CategoryBag;
import org.apache.juddi.datatype.KeyedReference;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.publisher.Publisher;
import org.apache.juddi.datatype.request.AuthInfo;
import org.apache.juddi.datatype.request.SaveTModel;
import org.apache.juddi.datatype.response.TModelDetail;
import org.apache.juddi.datatype.tmodel.TModel;
import org.apache.juddi.error.InvalidKeyPassedException;
import org.apache.juddi.error.RegistryException;
import org.apache.juddi.error.UnsupportedException;
import org.apache.juddi.error.UserMismatchException;
import org.apache.juddi.function.AbstractFunction;
import org.apache.juddi.registry.RegistryEngine;
import org.apache.juddi.util.Config;
import org.apache.juddi.uuidgen.UUIDGen;
import org.apache.juddi.uuidgen.UUIDGenFactory;

public class SaveTModelFunction
extends AbstractFunction {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$juddi$function$SaveTModelFunction == null ? (class$org$apache$juddi$function$SaveTModelFunction = SaveTModelFunction.class$("org.apache.juddi.function.SaveTModelFunction")) : class$org$apache$juddi$function$SaveTModelFunction));
    static /* synthetic */ Class class$org$apache$juddi$function$SaveTModelFunction;

    public SaveTModelFunction(RegistryEngine registry) {
        super(registry);
    }

    public RegistryObject execute(RegistryObject regObject) throws RegistryException {
        SaveTModel request = (SaveTModel)regObject;
        String generic = request.getGeneric();
        AuthInfo authInfo = request.getAuthInfo();
        Vector tModelVector = request.getTModelVector();
        Vector uploadRegVector = request.getUploadRegisterVector();
        UUIDGen uuidgen = UUIDGenFactory.getUUIDGen();
        if (uploadRegVector != null && uploadRegVector.size() > 0) {
            throw new UnsupportedException("Saving TModels via UploadRegistry is not supported.");
        }
        DataStore dataStore = DataStoreFactory.getDataStore();
        try {
            String tModelKey;
            TModel tModel;
            int i;
            dataStore.beginTrans();
            Publisher publisher = this.getPublisher(authInfo, dataStore);
            String publisherID = publisher.getPublisherID();
            String authorizedName = publisher.getName();
            for (i = 0; i < tModelVector.size(); ++i) {
                int vectorSize;
                Vector keyedRefVector;
                tModel = (TModel)tModelVector.elementAt(i);
                tModelKey = tModel.getTModelKey();
                if (tModelKey != null && tModelKey.length() > 0 && !dataStore.isValidTModelKey(tModelKey)) {
                    throw new InvalidKeyPassedException("TModelKey: " + tModelKey);
                }
                if (tModelKey != null && tModelKey.length() > 0 && !dataStore.isTModelPublisher(tModelKey, publisherID)) {
                    throw new UserMismatchException("TModelKey: " + tModelKey);
                }
                CategoryBag categoryBag = tModel.getCategoryBag();
                if (categoryBag == null || (keyedRefVector = categoryBag.getKeyedReferenceVector()) == null || (vectorSize = keyedRefVector.size()) <= 0) continue;
                for (int j = 0; j < vectorSize; ++j) {
                    KeyedReference keyedRef = (KeyedReference)keyedRefVector.elementAt(j);
                    String key = keyedRef.getTModelKey();
                    if (key != null && key.trim().length() != 0) continue;
                    keyedRef.setTModelKey("UUID:A035A07C-F362-44dd-8F95-E2B134BF43B4");
                }
            }
            for (i = 0; i < tModelVector.size(); ++i) {
                tModel = (TModel)tModelVector.elementAt(i);
                tModelKey = tModel.getTModelKey();
                if (tModelKey != null && tModelKey.length() > 0) {
                    dataStore.deleteTModel(tModelKey);
                } else {
                    tModel.setTModelKey("uuid:" + uuidgen.uuidgen());
                }
                tModel.setAuthorizedName(authorizedName);
                tModel.setOperator(Config.getOperator());
                dataStore.saveTModel(tModel, publisherID);
            }
            dataStore.commit();
            TModelDetail detail = new TModelDetail();
            detail.setGeneric(generic);
            detail.setOperator(Config.getOperator());
            detail.setTruncated(false);
            detail.setTModelVector(tModelVector);
            TModelDetail tModelDetail = detail;
            return tModelDetail;
        }
        catch (UnsupportedException suppex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.info((Object)suppex);
            throw suppex;
        }
        catch (InvalidKeyPassedException ikpex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.info((Object)ikpex);
            throw ikpex;
        }
        catch (UserMismatchException umex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.info((Object)umex);
            throw umex;
        }
        catch (RegistryException regex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.error((Object)regex);
            throw regex;
        }
        catch (Exception ex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.error((Object)ex);
            throw new RegistryException(ex);
        }
        finally {
            if (dataStore != null) {
                dataStore.release();
            }
        }
    }

    public static void main(String[] args) {
        RegistryEngine reg = new RegistryEngine();
        reg.init();
        reg.dispose();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

