/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.handler;

import java.util.Vector;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.assertion.PublisherAssertion;
import org.apache.juddi.datatype.request.AddPublisherAssertions;
import org.apache.juddi.datatype.request.AuthInfo;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.apache.juddi.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class AddPublisherAssertionsHandler
extends AbstractHandler {
    public static final String TAG_NAME = "add_publisherAssertions";
    private HandlerMaker maker = null;

    protected AddPublisherAssertionsHandler(HandlerMaker maker) {
        this.maker = maker;
    }

    public RegistryObject unmarshal(Element element) {
        AddPublisherAssertions obj = new AddPublisherAssertions();
        Vector nodeList = null;
        AbstractHandler handler = null;
        String generic = element.getAttribute("generic");
        if (generic != null && generic.trim().length() > 0) {
            obj.setGeneric(generic);
        }
        if ((nodeList = XMLUtils.getChildElementsByTagName(element, "authInfo")).size() > 0) {
            handler = this.maker.lookup("authInfo");
            obj.setAuthInfo((AuthInfo)handler.unmarshal((Element)nodeList.elementAt(0)));
        }
        nodeList = XMLUtils.getChildElementsByTagName(element, "publisherAssertion");
        for (int i = 0; i < nodeList.size(); ++i) {
            handler = this.maker.lookup("publisherAssertion");
            obj.addPublisherAssertion((PublisherAssertion)handler.unmarshal((Element)nodeList.elementAt(i)));
        }
        return obj;
    }

    public void marshal(RegistryObject object, Element parent) {
        Vector vector;
        AuthInfo authInfo;
        AddPublisherAssertions request = (AddPublisherAssertions)object;
        Element element = parent.getOwnerDocument().createElement(TAG_NAME);
        String generic = request.getGeneric();
        if (generic != null) {
            element.setAttribute("generic", generic);
        }
        if ((authInfo = request.getAuthInfo()) != null) {
            AbstractHandler handler = this.maker.lookup("authInfo");
            handler.marshal(authInfo, element);
        }
        if ((vector = request.getPublisherAssertionVector()) != null && vector.size() > 0) {
            AbstractHandler handler = this.maker.lookup("publisherAssertion");
            for (int i = 0; i < vector.size(); ++i) {
                handler.marshal((PublisherAssertion)vector.elementAt(i), element);
            }
        }
        parent.appendChild(element);
    }

    public static void main(String[] args) throws Exception {
        HandlerMaker maker = HandlerMaker.getInstance();
        AbstractHandler handler = maker.lookup(TAG_NAME);
        Element parent = XMLUtils.newRootElement();
        Element child = null;
        AuthInfo authInfo = new AuthInfo();
        authInfo.setValue("6f157513-844e-4a95-a856-d257e6ba9726");
        PublisherAssertion assertion = new PublisherAssertion();
        assertion.setFromKey("3379ec11-a509-4668-9fee-19b134d0d09b");
        assertion.setToKey("3379ec11-a509-4668-9fee-19b134d0d09b");
        assertion.setKeyName("paKeyName");
        assertion.setKeyValue("paKeyValue");
        assertion.setTModelKey("uuid:3379ec11-a509-4668-9fee-19b134d0d09b");
        AddPublisherAssertions service = new AddPublisherAssertions();
        service.setAuthInfo(authInfo);
        service.addPublisherAssertion(assertion);
        service.addPublisherAssertion(assertion);
        System.out.println();
        RegistryObject regObject = service;
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
        System.out.println();
        regObject = handler.unmarshal(child);
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
    }
}

