/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.handler;

import java.util.Vector;
import org.apache.juddi.datatype.Address;
import org.apache.juddi.datatype.AddressLine;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.apache.juddi.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class AddressHandler
extends AbstractHandler {
    public static final String TAG_NAME = "address";
    private HandlerMaker maker = null;

    protected AddressHandler(HandlerMaker maker) {
        this.maker = maker;
    }

    public RegistryObject unmarshal(Element element) {
        String tModelKey;
        String sortCode;
        Address obj = new Address();
        Vector nodeList = null;
        AbstractHandler handler = null;
        String useType = element.getAttribute("useType");
        if (useType != null && useType.trim().length() > 0) {
            obj.setUseType(useType);
        }
        if ((sortCode = element.getAttribute("sortCode")) != null && sortCode.trim().length() > 0) {
            obj.setSortCode(sortCode);
        }
        if ((tModelKey = element.getAttribute("tModelKey")) != null && tModelKey.trim().length() > 0) {
            obj.setTModelKey(tModelKey);
        }
        handler = this.maker.lookup("addressLine");
        nodeList = XMLUtils.getChildElementsByTagName(element, "addressLine");
        for (int i = 0; i < nodeList.size(); ++i) {
            obj.addAddressLine((AddressLine)handler.unmarshal((Element)nodeList.elementAt(i)));
        }
        return obj;
    }

    public void marshal(RegistryObject object, Element parent) {
        Vector vector;
        String tModelKey;
        String sortCode;
        Address address = (Address)object;
        Element element = parent.getOwnerDocument().createElement(TAG_NAME);
        String useType = address.getUseType();
        if (useType != null && useType.trim().length() > 0) {
            element.setAttribute("useType", useType);
        }
        if ((sortCode = address.getSortCode()) != null && sortCode.trim().length() > 0) {
            element.setAttribute("sortCode", sortCode);
        }
        if ((tModelKey = address.getTModelKey()) != null && tModelKey.trim().length() > 0) {
            element.setAttribute("tModelKey", tModelKey);
        }
        if ((vector = address.getAddressLineVector()) != null && vector.size() > 0) {
            AbstractHandler handler = this.maker.lookup("addressLine");
            for (int i = 0; i < vector.size(); ++i) {
                AddressLine addressLine = (AddressLine)vector.elementAt(i);
                handler.marshal(addressLine, element);
            }
        }
        parent.appendChild(element);
    }

    public static void main(String[] args) throws Exception {
        HandlerMaker maker = HandlerMaker.getInstance();
        AbstractHandler handler = maker.lookup(TAG_NAME);
        Element parent = XMLUtils.newRootElement();
        Element child = null;
        Address object = new Address();
        object.setUseType("myAddressUseType");
        object.setSortCode("sortThis");
        object.setTModelKey(null);
        object.addAddressLine(new AddressLine("AddressLine1", "keyNameAttr", "keyValueAttr"));
        object.addAddressLine(new AddressLine("AddressLine2"));
        System.out.println();
        RegistryObject regObject = object;
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
        System.out.println();
        regObject = handler.unmarshal(child);
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
        System.out.println();
    }
}

