/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.handler;

import org.apache.juddi.datatype.AddressLine;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.apache.juddi.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class AddressLineHandler
extends AbstractHandler {
    public static final String TAG_NAME = "addressLine";
    private HandlerMaker maker = null;

    protected AddressLineHandler(HandlerMaker maker) {
        this.maker = maker;
    }

    public RegistryObject unmarshal(Element element) {
        String keyValue;
        AddressLine obj = new AddressLine();
        String keyName = element.getAttribute("keyName");
        if (keyName != null && keyName.trim().length() > 0) {
            obj.setKeyName(keyName);
        }
        if ((keyValue = element.getAttribute("keyValue")) != null && keyValue.trim().length() > 0) {
            obj.setKeyValue(keyValue);
        }
        obj.setLineValue(XMLUtils.getText(element));
        return obj;
    }

    public void marshal(RegistryObject object, Element parent) {
        String lineValue;
        String keyValue;
        AddressLine line = (AddressLine)object;
        Element element = parent.getOwnerDocument().createElement(TAG_NAME);
        String keyName = line.getKeyName();
        if (keyName != null && keyName.trim().length() > 0) {
            element.setAttribute("keyName", keyName);
        }
        if ((keyValue = line.getKeyValue()) != null && keyValue.trim().length() > 0) {
            element.setAttribute("keyValue", keyValue);
        }
        if ((lineValue = line.getLineValue()) != null) {
            element.appendChild(parent.getOwnerDocument().createTextNode(lineValue));
        }
        parent.appendChild(element);
    }

    public static void main(String[] args) throws Exception {
        AddressLine lineIn = new AddressLine("AddressLine1", "keyNameAttr", "keyValueAttr");
        HandlerMaker maker = HandlerMaker.getInstance();
        AbstractHandler handler = maker.lookup(TAG_NAME);
        Element element = null;
        handler.marshal(lineIn, element);
        AddressLine lineOut = (AddressLine)handler.unmarshal(element);
        if (lineOut.equals(lineIn)) {
            System.out.println("Input and output are the same.");
        } else {
            System.out.println("Input and output are NOT the same!");
        }
    }
}

