/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.handler;

import java.util.Vector;
import org.apache.juddi.datatype.KeyedReference;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.response.AssertionStatusItem;
import org.apache.juddi.datatype.response.CompletionStatus;
import org.apache.juddi.datatype.response.KeysOwned;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.apache.juddi.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class AssertionStatusItemHandler
extends AbstractHandler {
    public static final String TAG_NAME = "assertionStatusItem";
    private static final String FROM_KEY_TAG_NAME = "fromKey";
    private static final String TO_KEY_TAG_NAME = "toKey";
    private HandlerMaker maker = null;

    protected AssertionStatusItemHandler(HandlerMaker maker) {
        this.maker = maker;
    }

    public RegistryObject unmarshal(Element element) {
        Element keyElement;
        AssertionStatusItem obj = new AssertionStatusItem();
        Vector nodeList = null;
        AbstractHandler handler = null;
        obj.setCompletionStatus(element.getAttribute("completionStatus"));
        nodeList = XMLUtils.getChildElementsByTagName(element, FROM_KEY_TAG_NAME);
        if (nodeList.size() > 0) {
            keyElement = (Element)nodeList.elementAt(0);
            obj.setFromKey(XMLUtils.getText(keyElement));
        }
        if ((nodeList = XMLUtils.getChildElementsByTagName(element, TO_KEY_TAG_NAME)).size() > 0) {
            keyElement = (Element)nodeList.elementAt(0);
            obj.setToKey(XMLUtils.getText(keyElement));
        }
        if ((nodeList = XMLUtils.getChildElementsByTagName(element, "keyedReference")).size() > 0) {
            handler = this.maker.lookup("keyedReference");
            obj.setKeyedReference((KeyedReference)handler.unmarshal((Element)nodeList.elementAt(0)));
        }
        if ((nodeList = XMLUtils.getChildElementsByTagName(element, "keysOwned")).size() > 0) {
            handler = this.maker.lookup("keysOwned");
            obj.setKeysOwned((KeysOwned)handler.unmarshal((Element)nodeList.elementAt(0)));
        }
        return obj;
    }

    public void marshal(RegistryObject object, Element parent) {
        KeysOwned keysOwned;
        KeyedReference keyedRef;
        String toKey;
        String fromKey;
        AssertionStatusItem item = (AssertionStatusItem)object;
        Element element = parent.getOwnerDocument().createElement(TAG_NAME);
        AbstractHandler handler = null;
        CompletionStatus status = item.getCompletionStatus();
        if (status != null && status.getValue() != null) {
            element.setAttribute("completionStatus", status.getValue());
        }
        if ((fromKey = item.getFromKey()) != null) {
            Element keyElement = parent.getOwnerDocument().createElement(FROM_KEY_TAG_NAME);
            keyElement.appendChild(parent.getOwnerDocument().createTextNode(fromKey));
            element.appendChild(keyElement);
        }
        if ((toKey = item.getToKey()) != null) {
            Element keyElement = parent.getOwnerDocument().createElement(TO_KEY_TAG_NAME);
            keyElement.appendChild(parent.getOwnerDocument().createTextNode(toKey));
            element.appendChild(keyElement);
        }
        if ((keyedRef = item.getKeyedReference()) != null) {
            handler = this.maker.lookup("keyedReference");
            handler.marshal(keyedRef, element);
        }
        if ((keysOwned = item.getKeysOwned()) != null) {
            handler = this.maker.lookup("keysOwned");
            handler.marshal(keysOwned, element);
        }
        parent.appendChild(element);
    }

    public static void main(String[] args) throws Exception {
        HandlerMaker maker = HandlerMaker.getInstance();
        AbstractHandler handler = maker.lookup(TAG_NAME);
        Element parent = XMLUtils.newRootElement();
        Element child = null;
        KeysOwned keysOwned = new KeysOwned();
        keysOwned.setToKey("dfddb58c-4853-4a71-865c-f84509017cc7");
        keysOwned.setFromKey("fe8af00d-3a2c-4e05-b7ca-95a1259aad4f");
        AssertionStatusItem item = new AssertionStatusItem();
        item.setCompletionStatus(new CompletionStatus("status:complete"));
        item.setFromKey("986d9a16-5d4d-46cf-9fac-6bb80a7091f6");
        item.setToKey("dd45a24c-74fc-4e82-80c2-f99cdc76d681");
        item.setKeyedReference(new KeyedReference("uuid:8ff45356-acde-4a4c-86bf-f953611d20c6", "Subsidiary", "1"));
        item.setKeysOwned(keysOwned);
        System.out.println();
        RegistryObject regObject = item;
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
        System.out.println();
        regObject = handler.unmarshal(child);
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
    }
}

