/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.handler;

import java.util.Vector;
import org.apache.juddi.datatype.KeyedReference;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.response.AssertionStatusItem;
import org.apache.juddi.datatype.response.AssertionStatusReport;
import org.apache.juddi.datatype.response.CompletionStatus;
import org.apache.juddi.datatype.response.KeysOwned;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.apache.juddi.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class AssertionStatusReportHandler
extends AbstractHandler {
    public static final String TAG_NAME = "assertionStatusReport";
    private HandlerMaker maker = null;

    protected AssertionStatusReportHandler(HandlerMaker maker) {
        this.maker = maker;
    }

    public RegistryObject unmarshal(Element element) {
        AssertionStatusReport obj = new AssertionStatusReport();
        Vector nodeList = null;
        AbstractHandler handler = null;
        obj.setGeneric(element.getAttribute("generic"));
        obj.setOperator(element.getAttribute("operator"));
        nodeList = XMLUtils.getChildElementsByTagName(element, "assertionStatusItem");
        for (int i = 0; i < nodeList.size(); ++i) {
            handler = this.maker.lookup("assertionStatusItem");
            obj.addAssertionStatusItem((AssertionStatusItem)handler.unmarshal((Element)nodeList.elementAt(i)));
        }
        return obj;
    }

    public void marshal(RegistryObject object, Element parent) {
        Vector vector;
        String operator;
        AssertionStatusReport report = (AssertionStatusReport)object;
        Element element = parent.getOwnerDocument().createElement(TAG_NAME);
        AbstractHandler handler = null;
        String generic = report.getGeneric();
        if (generic != null) {
            element.setAttribute("generic", generic);
            if (generic.equals("1.0")) {
                element.setAttribute("xmlns", "urn:uddi-org:api");
            } else if (generic.equals("2.0")) {
                element.setAttribute("xmlns", "urn:uddi-org:api_v2");
            } else if (generic.equals("3.0")) {
                element.setAttribute("xmlns", "urn:uddi-org:api_v3");
            }
        }
        if ((operator = report.getOperator()) != null) {
            element.setAttribute("operator", operator);
        }
        if ((vector = report.getAssertionStatusItemVector()) != null && vector.size() > 0) {
            handler = this.maker.lookup("assertionStatusItem");
            for (int i = 0; i < vector.size(); ++i) {
                handler.marshal((AssertionStatusItem)vector.elementAt(i), element);
            }
        }
        parent.appendChild(element);
    }

    public static void main(String[] args) throws Exception {
        HandlerMaker maker = HandlerMaker.getInstance();
        AbstractHandler handler = maker.lookup(TAG_NAME);
        Element parent = XMLUtils.newRootElement();
        Element child = null;
        KeysOwned keysOwned = new KeysOwned();
        keysOwned.setFromKey("fe8af00d-3a2c-4e05-b7ca-95a1259aad4f");
        keysOwned.setToKey("dfddb58c-4853-4a71-865c-f84509017cc7");
        AssertionStatusItem item = new AssertionStatusItem();
        item.setFromKey("986d9a16-5d4d-46cf-9fac-6bb80a7091f6");
        item.setToKey("dd45a24c-74fc-4e82-80c2-f99cdc76d681");
        item.setKeyedReference(new KeyedReference("uuid:8ff45356-acde-4a4c-86bf-f953611d20c6", "Subsidiary", "1"));
        item.setCompletionStatus(new CompletionStatus("status:complete"));
        item.setKeysOwned(keysOwned);
        AssertionStatusReport report = new AssertionStatusReport();
        report.setGeneric("2.0");
        report.setOperator("jUDDI.org");
        report.addAssertionStatusItem(item);
        report.addAssertionStatusItem(item);
        System.out.println();
        RegistryObject regObject = report;
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
        System.out.println();
        regObject = handler.unmarshal(child);
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
    }
}

