/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.handler;

import java.util.Vector;
import org.apache.juddi.datatype.CategoryBag;
import org.apache.juddi.datatype.Description;
import org.apache.juddi.datatype.OverviewDoc;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.binding.AccessPoint;
import org.apache.juddi.datatype.binding.BindingTemplate;
import org.apache.juddi.datatype.binding.HostingRedirector;
import org.apache.juddi.datatype.binding.InstanceDetails;
import org.apache.juddi.datatype.binding.TModelInstanceDetails;
import org.apache.juddi.datatype.binding.TModelInstanceInfo;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.apache.juddi.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class BindingTemplateHandler
extends AbstractHandler {
    public static final String TAG_NAME = "bindingTemplate";
    private HandlerMaker maker = null;

    protected BindingTemplateHandler(HandlerMaker maker) {
        this.maker = maker;
    }

    public RegistryObject unmarshal(Element element) {
        BindingTemplate obj = new BindingTemplate();
        Vector nodeList = null;
        AbstractHandler handler = null;
        obj.setServiceKey(element.getAttribute("serviceKey"));
        obj.setBindingKey(element.getAttribute("bindingKey"));
        nodeList = XMLUtils.getChildElementsByTagName(element, "description");
        for (int i = 0; i < nodeList.size(); ++i) {
            handler = this.maker.lookup("description");
            obj.addDescription((Description)handler.unmarshal((Element)nodeList.elementAt(i)));
        }
        nodeList = XMLUtils.getChildElementsByTagName(element, "accessPoint");
        if (nodeList.size() > 0) {
            handler = this.maker.lookup("accessPoint");
            obj.setAccessPoint((AccessPoint)handler.unmarshal((Element)nodeList.elementAt(0)));
        }
        if ((nodeList = XMLUtils.getChildElementsByTagName(element, "hostingRedirector")).size() > 0) {
            handler = this.maker.lookup("hostingRedirector");
            obj.setHostingRedirector((HostingRedirector)handler.unmarshal((Element)nodeList.elementAt(0)));
        }
        if ((nodeList = XMLUtils.getChildElementsByTagName(element, "tModelInstanceDetails")).size() > 0) {
            handler = this.maker.lookup("tModelInstanceDetails");
            obj.setTModelInstanceDetails((TModelInstanceDetails)handler.unmarshal((Element)nodeList.elementAt(0)));
        }
        if ((nodeList = XMLUtils.getChildElementsByTagName(element, "categoryBag")).size() > 0) {
            handler = this.maker.lookup("categoryBag");
            obj.setCategoryBag((CategoryBag)handler.unmarshal((Element)nodeList.elementAt(0)));
        }
        return obj;
    }

    public void marshal(RegistryObject object, Element parent) {
        CategoryBag categoryBag;
        TModelInstanceDetails tModInstDet;
        HostingRedirector redirector;
        AccessPoint accessPoint;
        Vector descrVector;
        String bindingKey;
        BindingTemplate binding = (BindingTemplate)object;
        Element element = parent.getOwnerDocument().createElement(TAG_NAME);
        AbstractHandler handler = null;
        String serviceKey = binding.getServiceKey();
        if (serviceKey != null) {
            element.setAttribute("serviceKey", serviceKey);
        }
        if ((bindingKey = binding.getBindingKey()) != null) {
            element.setAttribute("bindingKey", bindingKey);
        }
        if ((descrVector = binding.getDescriptionVector()) != null && descrVector.size() > 0) {
            handler = this.maker.lookup("description");
            for (int i = 0; i < descrVector.size(); ++i) {
                handler.marshal((Description)descrVector.elementAt(i), element);
            }
        }
        if ((accessPoint = binding.getAccessPoint()) != null) {
            handler = this.maker.lookup("accessPoint");
            handler.marshal(accessPoint, element);
        }
        if ((redirector = binding.getHostingRedirector()) != null) {
            handler = this.maker.lookup("hostingRedirector");
            handler.marshal(redirector, element);
        }
        if ((tModInstDet = binding.getTModelInstanceDetails()) != null) {
            handler = this.maker.lookup("tModelInstanceDetails");
            handler.marshal(tModInstDet, element);
        }
        if ((categoryBag = binding.getCategoryBag()) != null) {
            handler = this.maker.lookup("categoryBag");
            handler.marshal(categoryBag, element);
        }
        parent.appendChild(element);
    }

    public static void main(String[] args) throws Exception {
        HandlerMaker maker = HandlerMaker.getInstance();
        AbstractHandler handler = maker.lookup(TAG_NAME);
        Element parent = XMLUtils.newRootElement();
        Element child = null;
        OverviewDoc overDoc = new OverviewDoc();
        overDoc.setOverviewURL("http://www.sviens.com/service.html");
        overDoc.addDescription(new Description("over-doc Descr"));
        overDoc.addDescription(new Description("over-doc Descr Two", "en"));
        InstanceDetails instDetails = new InstanceDetails();
        instDetails.addDescription(new Description("body-isa-wunder"));
        instDetails.addDescription(new Description("sweetchild-o-mine", "it"));
        instDetails.setInstanceParms("inst-det parameters");
        instDetails.setOverviewDoc(overDoc);
        TModelInstanceInfo tModInstInfo = new TModelInstanceInfo();
        tModInstInfo.setTModelKey("uuid:ae0f9fd4-287f-40c9-be91-df47a7c72fd9");
        tModInstInfo.addDescription(new Description("tMod-Inst-Info"));
        tModInstInfo.addDescription(new Description("tMod-Inst-Info too", "es"));
        tModInstInfo.setInstanceDetails(instDetails);
        TModelInstanceDetails tModInstDet = new TModelInstanceDetails();
        tModInstDet.addTModelInstanceInfo(tModInstInfo);
        BindingTemplate binding = new BindingTemplate();
        binding.setBindingKey("c9613c3c-fe55-4f34-a3da-b3167afbca4a");
        binding.setServiceKey("997a55bc-563d-4c04-8a94-781604870d31");
        binding.addDescription(new Description("whatever"));
        binding.addDescription(new Description("whatever too", "fr"));
        binding.setHostingRedirector(new HostingRedirector("92658289-0bd7-443c-8948-0bb4460b44c0"));
        binding.setAccessPoint(new AccessPoint("http", "http://www.sviens.com/service.wsdl"));
        binding.setTModelInstanceDetails(tModInstDet);
        System.out.println();
        RegistryObject regObject = binding;
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
        System.out.println();
        regObject = handler.unmarshal(child);
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
        System.out.println();
    }
}

