/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.handler;

import java.util.Vector;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.business.BusinessEntityExt;
import org.apache.juddi.datatype.response.BusinessDetailExt;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.apache.juddi.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class BusinessDetailExtHandler
extends AbstractHandler {
    public static final String TAG_NAME = "businessDetailExt";
    private HandlerMaker maker = null;

    protected BusinessDetailExtHandler(HandlerMaker maker) {
        this.maker = maker;
    }

    public RegistryObject unmarshal(Element element) {
        BusinessDetailExt obj = new BusinessDetailExt();
        Vector nodeList = null;
        AbstractHandler handler = null;
        obj.setGeneric(element.getAttribute("generic"));
        obj.setOperator(element.getAttribute("operator"));
        String truncValue = element.getAttribute("truncated");
        if (truncValue != null) {
            obj.setTruncated(truncValue.equalsIgnoreCase("true"));
        }
        nodeList = XMLUtils.getChildElementsByTagName(element, "businessEntityExt");
        for (int i = 0; i < nodeList.size(); ++i) {
            handler = this.maker.lookup("businessEntityExt");
            obj.addBusinessEntityExt((BusinessEntityExt)handler.unmarshal((Element)nodeList.elementAt(i)));
        }
        return obj;
    }

    public void marshal(RegistryObject object, Element parent) {
        Vector vector;
        boolean truncated;
        String operator;
        BusinessDetailExt detail = (BusinessDetailExt)object;
        Element element = parent.getOwnerDocument().createElement(TAG_NAME);
        AbstractHandler handler = null;
        String generic = detail.getGeneric();
        if (generic != null) {
            element.setAttribute("generic", generic);
            if (generic.equals("1.0")) {
                element.setAttribute("xmlns", "urn:uddi-org:api");
            } else if (generic.equals("2.0")) {
                element.setAttribute("xmlns", "urn:uddi-org:api_v2");
            } else if (generic.equals("3.0")) {
                element.setAttribute("xmlns", "urn:uddi-org:api_v3");
            }
        }
        if ((operator = detail.getOperator()) != null) {
            element.setAttribute("operator", operator);
        }
        if (truncated = detail.isTruncated()) {
            element.setAttribute("truncated", "true");
        }
        if ((vector = detail.getBusinessEntityExtVector()) != null && vector.size() > 0) {
            handler = this.maker.lookup("businessEntityExt");
            for (int i = 0; i < vector.size(); ++i) {
                handler.marshal((BusinessEntityExt)vector.elementAt(i), element);
            }
        }
        parent.appendChild(element);
    }

    public static void main(String[] args) throws Exception {
    }
}

