/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.handler;

import java.util.Vector;
import org.apache.juddi.datatype.CategoryBag;
import org.apache.juddi.datatype.KeyedReference;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.apache.juddi.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class CategoryBagHandler
extends AbstractHandler {
    public static final String TAG_NAME = "categoryBag";
    private HandlerMaker maker = null;

    protected CategoryBagHandler(HandlerMaker maker) {
        this.maker = maker;
    }

    public RegistryObject unmarshal(Element element) {
        CategoryBag obj = new CategoryBag();
        Vector nodeList = null;
        AbstractHandler handler = null;
        nodeList = XMLUtils.getChildElementsByTagName(element, "keyedReference");
        for (int i = 0; i < nodeList.size(); ++i) {
            handler = this.maker.lookup("keyedReference");
            obj.addKeyedReference((KeyedReference)handler.unmarshal((Element)nodeList.elementAt(i)));
        }
        return obj;
    }

    public void marshal(RegistryObject object, Element parent) {
        CategoryBag categoryBag = (CategoryBag)object;
        Element element = parent.getOwnerDocument().createElement(TAG_NAME);
        Vector keyedRefVector = categoryBag.getKeyedReferenceVector();
        if (keyedRefVector != null && keyedRefVector.size() > 0) {
            AbstractHandler handler = this.maker.lookup("keyedReference");
            for (int i = 0; i < keyedRefVector.size(); ++i) {
                handler.marshal((KeyedReference)keyedRefVector.elementAt(i), element);
            }
        }
        parent.appendChild(element);
    }

    public static void main(String[] args) throws Exception {
        HandlerMaker maker = HandlerMaker.getInstance();
        AbstractHandler handler = maker.lookup(TAG_NAME);
        Element parent = XMLUtils.newRootElement();
        Element child = null;
        CategoryBag categoryBag = new CategoryBag();
        categoryBag.addKeyedReference(new KeyedReference("catBagKeyName", "catBagKeyValue"));
        categoryBag.addKeyedReference(new KeyedReference("uuid:8ff45356-acde-4a4c-86bf-f953611d20c6", "catBagKeyName2", "catBagKeyValue2"));
        System.out.println();
        RegistryObject regObject = categoryBag;
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
        System.out.println();
        regObject = handler.unmarshal(child);
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
    }
}

