/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.handler;

import java.util.Vector;
import org.apache.juddi.datatype.Address;
import org.apache.juddi.datatype.AddressLine;
import org.apache.juddi.datatype.Description;
import org.apache.juddi.datatype.Email;
import org.apache.juddi.datatype.Phone;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.business.Contact;
import org.apache.juddi.datatype.business.Contacts;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.apache.juddi.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class ContactsHandler
extends AbstractHandler {
    public static final String TAG_NAME = "contacts";
    private HandlerMaker maker = null;

    protected ContactsHandler(HandlerMaker maker) {
        this.maker = maker;
    }

    public RegistryObject unmarshal(Element element) {
        Contacts obj = new Contacts();
        Vector nodeList = null;
        AbstractHandler handler = null;
        nodeList = XMLUtils.getChildElementsByTagName(element, "contact");
        for (int i = 0; i < nodeList.size(); ++i) {
            handler = this.maker.lookup("contact");
            obj.addContact((Contact)handler.unmarshal((Element)nodeList.elementAt(i)));
        }
        return obj;
    }

    public void marshal(RegistryObject object, Element parent) {
        Contacts contacts = (Contacts)object;
        Element element = parent.getOwnerDocument().createElement(TAG_NAME);
        AbstractHandler handler = null;
        Vector contactVector = contacts.getContactVector();
        if (contactVector != null && contactVector.size() > 0) {
            handler = this.maker.lookup("contact");
            for (int i = 0; i < contactVector.size(); ++i) {
                handler.marshal((Contact)contactVector.elementAt(i), element);
            }
        }
        parent.appendChild(element);
    }

    public static void main(String[] args) throws Exception {
        HandlerMaker maker = HandlerMaker.getInstance();
        AbstractHandler handler = maker.lookup(TAG_NAME);
        Element parent = XMLUtils.newRootElement();
        Element child = null;
        Address address = new Address();
        address.setUseType("myAddressUseType");
        address.setSortCode("sortThis");
        address.setTModelKey(null);
        address.addAddressLine(new AddressLine("AddressLine1", "keyNameAttr", "keyValueAttr"));
        address.addAddressLine(new AddressLine("AddressLine2"));
        Contact contact = new Contact();
        contact.setUseType("myAddressUseType");
        contact.setPersonNameValue("Bob Whatever");
        contact.addDescription(new Description("Bob is a big fat jerk"));
        contact.addDescription(new Description("obBay sIay a igBay atFay erkJay", "es"));
        contact.addEmail(new Email("bob@whatever.com"));
        contact.addPhone(new Phone("(603)559-1901"));
        contact.addAddress(address);
        Contacts contacts = new Contacts();
        contacts.addContact(contact);
        contacts.addContact(contact);
        System.out.println();
        RegistryObject regObject = contacts;
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
        System.out.println();
        regObject = handler.unmarshal(child);
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
        System.out.println();
    }
}

