/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.handler;

import java.util.Vector;
import org.apache.juddi.datatype.DiscoveryURL;
import org.apache.juddi.datatype.DiscoveryURLs;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.apache.juddi.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class DiscoveryURLsHandler
extends AbstractHandler {
    public static final String TAG_NAME = "discoveryURLs";
    private HandlerMaker maker = null;

    protected DiscoveryURLsHandler(HandlerMaker maker) {
        this.maker = maker;
    }

    public RegistryObject unmarshal(Element element) {
        DiscoveryURLs obj = new DiscoveryURLs();
        Vector nodeList = null;
        AbstractHandler handler = null;
        nodeList = XMLUtils.getChildElementsByTagName(element, "discoveryURL");
        for (int i = 0; i < nodeList.size(); ++i) {
            handler = this.maker.lookup("discoveryURL");
            obj.addDiscoveryURL((DiscoveryURL)handler.unmarshal((Element)nodeList.elementAt(i)));
        }
        return obj;
    }

    public void marshal(RegistryObject object, Element parent) {
        DiscoveryURLs discURLs = (DiscoveryURLs)object;
        Element element = parent.getOwnerDocument().createElement(TAG_NAME);
        AbstractHandler handler = null;
        Vector discURLsVector = discURLs.getDiscoveryURLVector();
        if (discURLsVector != null && discURLsVector.size() > 0) {
            handler = this.maker.lookup("discoveryURL");
            for (int i = 0; i < discURLsVector.size(); ++i) {
                handler.marshal((DiscoveryURL)discURLsVector.elementAt(i), element);
            }
        }
        parent.appendChild(element);
    }

    public static void main(String[] args) throws Exception {
        HandlerMaker maker = HandlerMaker.getInstance();
        AbstractHandler handler = maker.lookup(TAG_NAME);
        Element parent = XMLUtils.newRootElement();
        Element child = null;
        DiscoveryURLs discoveryURLs = new DiscoveryURLs();
        discoveryURLs.addDiscoveryURL(new DiscoveryURL("businessEntity", "http://www.sviens.com"));
        System.out.println();
        RegistryObject regObject = discoveryURLs;
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
        System.out.println();
        regObject = handler.unmarshal(child);
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
    }
}

