/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.handler;

import java.util.Vector;
import org.apache.juddi.datatype.Name;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.request.FindPublisher;
import org.apache.juddi.datatype.request.FindQualifier;
import org.apache.juddi.datatype.request.FindQualifiers;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.apache.juddi.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class FindPublisherHandler
extends AbstractHandler {
    public static final String TAG_NAME = "find_publisher";
    private HandlerMaker maker = null;

    protected FindPublisherHandler(HandlerMaker maker) {
        this.maker = maker;
    }

    public RegistryObject unmarshal(Element element) {
        String maxRows;
        FindPublisher obj = new FindPublisher();
        Vector nodeList = null;
        AbstractHandler handler = null;
        String generic = element.getAttribute("generic");
        if (generic != null && generic.trim().length() > 0) {
            obj.setGeneric(generic);
        }
        if ((maxRows = element.getAttribute("maxRows")) != null && maxRows.length() > 0) {
            obj.setMaxRows(maxRows);
        }
        if ((nodeList = XMLUtils.getChildElementsByTagName(element, "name")).size() > 0) {
            handler = this.maker.lookup("name");
            obj.setName((Name)handler.unmarshal((Element)nodeList.elementAt(0)));
        }
        if ((nodeList = XMLUtils.getChildElementsByTagName(element, "findQualifiers")).size() > 0) {
            handler = this.maker.lookup("findQualifiers");
            obj.setFindQualifiers((FindQualifiers)handler.unmarshal((Element)nodeList.elementAt(0)));
        }
        return obj;
    }

    public void marshal(RegistryObject object, Element parent) {
        Name name;
        FindQualifiers qualifiers;
        int maxRows;
        FindPublisher request = (FindPublisher)object;
        Element element = parent.getOwnerDocument().createElement(TAG_NAME);
        AbstractHandler handler = null;
        String generic = request.getGeneric();
        if (generic != null) {
            element.setAttribute("generic", generic);
        }
        if ((maxRows = request.getMaxRows()) > 0) {
            element.setAttribute("maxRows", String.valueOf(maxRows));
        }
        if ((qualifiers = request.getFindQualifiers()) != null && qualifiers.size() > 0) {
            handler = this.maker.lookup("findQualifiers");
            handler.marshal(qualifiers, element);
        }
        if ((name = request.getName()) != null) {
            handler = this.maker.lookup("name");
            handler.marshal(name, element);
        }
        parent.appendChild(element);
    }

    public static void main(String[] args) throws Exception {
        HandlerMaker maker = HandlerMaker.getInstance();
        AbstractHandler handler = maker.lookup(TAG_NAME);
        Element parent = XMLUtils.newRootElement();
        Element child = null;
        FindPublisher request = new FindPublisher();
        request.setName(new Name("s", "en"));
        request.addFindQualifier(new FindQualifier("sortByNameAsc"));
        request.setMaxRows(50);
        System.out.println();
        RegistryObject regObject = request;
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
        System.out.println();
        regObject = handler.unmarshal(child);
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
    }
}

