/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.handler;

import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.request.FindQualifier;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.apache.juddi.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class FindQualifierHandler
extends AbstractHandler {
    public static final String TAG_NAME = "findQualifier";
    private HandlerMaker maker = null;

    protected FindQualifierHandler(HandlerMaker maker) {
        this.maker = maker;
    }

    public RegistryObject unmarshal(Element element) {
        FindQualifier obj = new FindQualifier();
        obj.setValue(XMLUtils.getText(element));
        return obj;
    }

    public void marshal(RegistryObject object, Element parent) {
        FindQualifier qualifier = (FindQualifier)object;
        Element element = parent.getOwnerDocument().createElement(TAG_NAME);
        String qValue = qualifier.getValue();
        if (qValue != null) {
            element.appendChild(parent.getOwnerDocument().createTextNode(qValue));
        }
        parent.appendChild(element);
    }

    public static void main(String[] args) throws Exception {
        HandlerMaker maker = HandlerMaker.getInstance();
        AbstractHandler handler = maker.lookup(TAG_NAME);
        Element parent = XMLUtils.newRootElement();
        Element child = null;
        FindQualifier qualifier = new FindQualifier("sortByNameAsc");
        System.out.println();
        RegistryObject regObject = qualifier;
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
        System.out.println();
        regObject = handler.unmarshal(child);
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
    }
}

