/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.handler;

import java.util.Vector;
import org.apache.juddi.datatype.IdentifierBag;
import org.apache.juddi.datatype.KeyedReference;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.apache.juddi.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class IdentifierBagHandler
extends AbstractHandler {
    public static final String TAG_NAME = "identifierBag";
    private HandlerMaker maker = null;

    protected IdentifierBagHandler(HandlerMaker maker) {
        this.maker = maker;
    }

    public RegistryObject unmarshal(Element element) {
        IdentifierBag obj = new IdentifierBag();
        Vector nodeList = null;
        AbstractHandler handler = null;
        nodeList = XMLUtils.getChildElementsByTagName(element, "keyedReference");
        for (int i = 0; i < nodeList.size(); ++i) {
            handler = this.maker.lookup("keyedReference");
            obj.addKeyedReference((KeyedReference)handler.unmarshal((Element)nodeList.elementAt(i)));
        }
        return obj;
    }

    public void marshal(RegistryObject object, Element parent) {
        IdentifierBag categoryBag = (IdentifierBag)object;
        Element element = parent.getOwnerDocument().createElement(TAG_NAME);
        AbstractHandler handler = null;
        Vector keyedRefVector = categoryBag.getKeyedReferenceVector();
        if (keyedRefVector != null && keyedRefVector.size() > 0) {
            handler = this.maker.lookup("keyedReference");
            for (int i = 0; i < keyedRefVector.size(); ++i) {
                handler.marshal((KeyedReference)keyedRefVector.elementAt(i), element);
            }
        }
        parent.appendChild(element);
    }

    public static void main(String[] args) throws Exception {
        HandlerMaker maker = HandlerMaker.getInstance();
        AbstractHandler handler = maker.lookup(TAG_NAME);
        Element parent = XMLUtils.newRootElement();
        Element child = null;
        IdentifierBag identifierBag = new IdentifierBag();
        identifierBag.addKeyedReference(new KeyedReference("idBagKeyName", "idBagKeyValue"));
        identifierBag.addKeyedReference(new KeyedReference("uuid:3860b975-9e0c-4cec-bad6-87dfe00e3864", "idBagKeyName2", "idBagKeyValue2"));
        System.out.println();
        RegistryObject regObject = identifierBag;
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
        System.out.println();
        regObject = handler.unmarshal(child);
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
    }
}

