/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.handler;

import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.binding.InstanceParms;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.apache.juddi.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class InstanceParmsHandler
extends AbstractHandler {
    public static final String TAG_NAME = "instanceParms";
    private HandlerMaker maker = null;

    protected InstanceParmsHandler(HandlerMaker maker) {
        this.maker = maker;
    }

    public RegistryObject unmarshal(Element element) {
        InstanceParms obj = new InstanceParms();
        obj.setText(XMLUtils.getText(element));
        return obj;
    }

    public void marshal(RegistryObject object, Element parent) {
        InstanceParms parms = (InstanceParms)object;
        Element element = parent.getOwnerDocument().createElement(TAG_NAME);
        String parmsValue = parms.getValue();
        if (parmsValue != null) {
            element.appendChild(parent.getOwnerDocument().createTextNode(parmsValue));
        }
        parent.appendChild(element);
    }

    public static void main(String[] args) throws Exception {
        HandlerMaker maker = HandlerMaker.getInstance();
        AbstractHandler handler = maker.lookup(TAG_NAME);
        Element parent = XMLUtils.newRootElement();
        Element child = null;
        InstanceParms instParms = new InstanceParms();
        instParms.setText("iParms-whatever");
        System.out.println();
        RegistryObject regObject = instParms;
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
        System.out.println();
        regObject = handler.unmarshal(child);
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
    }
}

