/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.handler;

import java.util.Vector;
import org.apache.juddi.datatype.Description;
import org.apache.juddi.datatype.OverviewDoc;
import org.apache.juddi.datatype.OverviewURL;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.apache.juddi.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class OverviewDocHandler
extends AbstractHandler {
    public static final String TAG_NAME = "overviewDoc";
    private HandlerMaker maker = null;

    protected OverviewDocHandler(HandlerMaker maker) {
        this.maker = maker;
    }

    public RegistryObject unmarshal(Element element) {
        OverviewDoc obj = new OverviewDoc();
        Vector nodeList = null;
        AbstractHandler handler = null;
        nodeList = XMLUtils.getChildElementsByTagName(element, "overviewURL");
        if (nodeList.size() > 0) {
            handler = this.maker.lookup("overviewURL");
            obj.setOverviewURL((OverviewURL)handler.unmarshal((Element)nodeList.elementAt(0)));
        }
        nodeList = XMLUtils.getChildElementsByTagName(element, "description");
        for (int i = 0; i < nodeList.size(); ++i) {
            handler = this.maker.lookup("description");
            obj.addDescription((Description)handler.unmarshal((Element)nodeList.elementAt(i)));
        }
        return obj;
    }

    public void marshal(RegistryObject object, Element parent) {
        Vector descrVector;
        OverviewDoc overDoc = (OverviewDoc)object;
        Element element = parent.getOwnerDocument().createElement(TAG_NAME);
        AbstractHandler handler = null;
        OverviewURL overURL = overDoc.getOverviewURL();
        if (overURL != null) {
            handler = this.maker.lookup("overviewURL");
            handler.marshal(overURL, element);
        }
        if ((descrVector = overDoc.getDescriptionVector()) != null && descrVector.size() > 0) {
            handler = this.maker.lookup("description");
            for (int i = 0; i < descrVector.size(); ++i) {
                handler.marshal((Description)descrVector.elementAt(i), element);
            }
        }
        parent.appendChild(element);
    }

    public static void main(String[] args) throws Exception {
    }
}

