/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.handler;

import org.apache.juddi.datatype.AddressLine;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.response.Property;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.w3c.dom.Element;

public class PropertyHandler
extends AbstractHandler {
    public static final String TAG_NAME = "property";
    private HandlerMaker maker = null;

    protected PropertyHandler(HandlerMaker maker) {
        this.maker = maker;
    }

    public RegistryObject unmarshal(Element element) {
        String value;
        Property obj = new Property();
        String name = element.getAttribute("name");
        if (name != null && name.trim().length() > 0) {
            obj.setName(name);
        }
        if ((value = element.getAttribute("value")) != null && value.trim().length() > 0) {
            obj.setValue(value);
        }
        return obj;
    }

    public void marshal(RegistryObject object, Element parent) {
        String value;
        Property property = (Property)object;
        Element element = parent.getOwnerDocument().createElement(TAG_NAME);
        String name = property.getName();
        if (name != null && name.trim().length() > 0) {
            element.setAttribute("name", name);
        }
        if ((value = property.getValue()) != null && value.trim().length() > 0) {
            element.setAttribute("value", value);
        }
        parent.appendChild(element);
    }

    public static void main(String[] args) throws Exception {
        Property inprop = new Property("nameAttr", "valueAttr");
        HandlerMaker maker = HandlerMaker.getInstance();
        AbstractHandler handler = maker.lookup(TAG_NAME);
        Element element = null;
        handler.marshal(inprop, element);
        AddressLine outprop = (AddressLine)handler.unmarshal(element);
        if (outprop.equals(inprop)) {
            System.out.println("Input and output are the same.");
        } else {
            System.out.println("Input and output are NOT the same!");
        }
    }
}

