/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.handler;

import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.publisher.Publisher;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.apache.juddi.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class PublisherHandler
extends AbstractHandler {
    public static final String TAG_NAME = "publisher";
    private HandlerMaker maker = null;

    protected PublisherHandler(HandlerMaker maker) {
        this.maker = maker;
    }

    public RegistryObject unmarshal(Element element) {
        String emailAddress;
        String pager;
        String mobilePhone;
        String workPhone;
        String middleInit;
        String lastName;
        Publisher obj = new Publisher();
        Object nodeList = null;
        Object handler = null;
        obj.setPublisherID(element.getAttribute("publisherID"));
        obj.setName(element.getAttribute("publisherName"));
        String admin = element.getAttribute("admin");
        if (admin != null && admin.length() > 0) {
            obj.setAdminValue(admin);
        } else {
            obj.setAdmin(false);
        }
        String enabled = element.getAttribute("enabled");
        if (enabled != null && enabled.length() > 0) {
            obj.setEnabledValue(enabled);
        } else {
            obj.setAdmin(false);
        }
        String firstName = element.getAttribute("firstName");
        if (firstName != null && firstName.length() > 0) {
            obj.setFirstName(firstName);
        }
        if ((lastName = element.getAttribute("lastName")) != null && lastName.length() > 0) {
            obj.setLastName(lastName);
        }
        if ((middleInit = element.getAttribute("middleInit")) != null && middleInit.length() > 0) {
            obj.setMiddleInit(middleInit);
        }
        if ((workPhone = element.getAttribute("workPhone")) != null && workPhone.length() > 0) {
            obj.setWorkPhone(workPhone);
        }
        if ((mobilePhone = element.getAttribute("mobilePhone")) != null && mobilePhone.length() > 0) {
            obj.setMobilePhone(mobilePhone);
        }
        if ((pager = element.getAttribute("pager")) != null && pager.length() > 0) {
            obj.setPager(pager);
        }
        if ((emailAddress = element.getAttribute("emailAddress")) != null && emailAddress.length() > 0) {
            obj.setEmailAddress(emailAddress);
        }
        return obj;
    }

    public void marshal(RegistryObject object, Element parent) {
        String emailAddress;
        String pager;
        String mobilePhone;
        String workPhone;
        String middleInit;
        String lastName;
        Publisher publisher = (Publisher)object;
        Element element = parent.getOwnerDocument().createElement(TAG_NAME);
        Object handler = null;
        String publisherID = publisher.getPublisherID();
        if (publisherID != null && publisherID.length() > 0) {
            element.setAttribute("publisherID", publisherID);
        } else {
            element.setAttribute("publisherID", "");
        }
        String publisherName = publisher.getName();
        if (publisherName != null && publisherName.length() > 0) {
            element.setAttribute("publisherName", publisherName);
        } else {
            element.setAttribute("publisherName", "");
        }
        element.setAttribute("admin", String.valueOf(publisher.isAdmin()));
        element.setAttribute("enabled", String.valueOf(publisher.isEnabled()));
        String firstName = publisher.getFirstName();
        if (firstName != null && firstName.length() > 0) {
            element.setAttribute("firstName", firstName);
        }
        if ((lastName = publisher.getLastName()) != null && lastName.length() > 0) {
            element.setAttribute("lastName", lastName);
        }
        if ((middleInit = publisher.getMiddleInit()) != null && middleInit.length() > 0) {
            element.setAttribute("middleInit", middleInit);
        }
        if ((workPhone = publisher.getWorkPhone()) != null && workPhone.length() > 0) {
            element.setAttribute("workPhone", workPhone);
        }
        if ((mobilePhone = publisher.getMobilePhone()) != null && mobilePhone.length() > 0) {
            element.setAttribute("mobilePhone", mobilePhone);
        }
        if ((pager = publisher.getPager()) != null && pager.length() > 0) {
            element.setAttribute("pager", pager);
        }
        if ((emailAddress = publisher.getEmailAddress()) != null && emailAddress.length() > 0) {
            element.setAttribute("emailAddress", emailAddress);
        }
        parent.appendChild(element);
    }

    public static void main(String[] args) throws Exception {
        HandlerMaker maker = HandlerMaker.getInstance();
        AbstractHandler handler = maker.lookup(TAG_NAME);
        Element parent = XMLUtils.newRootElement();
        Element child = null;
        Publisher publisher = new Publisher();
        publisher.setPublisherID("bcrosby");
        publisher.setName("Bing Crosby");
        publisher.setLastName("Crosby");
        publisher.setFirstName("Bing");
        publisher.setWorkPhone("978.123-4567");
        publisher.setMobilePhone("617-765-9876");
        publisher.setPager("800-123-4655 ID: 501");
        publisher.setEmailAddress("bcrosby@juddi.org");
        publisher.setAdmin(true);
        publisher.setEnabled(true);
        System.out.println();
        RegistryObject regObject = publisher;
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
        System.out.println();
        regObject = handler.unmarshal(child);
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
    }
}

