/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.handler;

import java.util.Vector;
import org.apache.juddi.datatype.Name;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.response.PublisherInfo;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.apache.juddi.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class PublisherInfoHandler
extends AbstractHandler {
    public static final String TAG_NAME = "publisherInfo";
    private HandlerMaker maker = null;

    protected PublisherInfoHandler(HandlerMaker maker) {
        this.maker = maker;
    }

    public RegistryObject unmarshal(Element element) {
        PublisherInfo obj = new PublisherInfo();
        Vector nodeList = null;
        AbstractHandler handler = null;
        obj.setPublisherID(element.getAttribute("publisherID"));
        nodeList = XMLUtils.getChildElementsByTagName(element, "name");
        if (nodeList.size() > 0) {
            handler = this.maker.lookup("name");
            obj.setName((Name)handler.unmarshal((Element)nodeList.elementAt(0)));
        }
        return obj;
    }

    public void marshal(RegistryObject object, Element parent) {
        Name name;
        PublisherInfo info = (PublisherInfo)object;
        Element element = parent.getOwnerDocument().createElement(TAG_NAME);
        AbstractHandler handler = null;
        String publisherID = info.getPublisherID();
        if (publisherID != null) {
            element.setAttribute("publisherID", publisherID);
        }
        if ((name = info.getName()) != null) {
            handler = this.maker.lookup("name");
            handler.marshal(name, element);
        }
        parent.appendChild(element);
    }

    public static void main(String[] args) throws Exception {
    }
}

