/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.handler;

import java.util.Iterator;
import java.util.Properties;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.response.Property;
import org.apache.juddi.datatype.response.RegistryInfo;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.apache.juddi.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class RegistryInfoHandler
extends AbstractHandler {
    public static final String TAG_NAME = "registryInfo";
    private HandlerMaker maker = null;

    protected RegistryInfoHandler(HandlerMaker maker) {
        this.maker = maker;
    }

    public RegistryObject unmarshal(Element element) {
        RegistryInfo obj = new RegistryInfo();
        Vector nodeList = null;
        AbstractHandler handler = null;
        nodeList = XMLUtils.getChildElementsByTagName(element, "property");
        for (int i = 0; i < nodeList.size(); ++i) {
            handler = this.maker.lookup("property");
            obj.addProperty((Property)handler.unmarshal((Element)nodeList.elementAt(i)));
        }
        return obj;
    }

    public void marshal(RegistryObject object, Element parent) {
        RegistryInfo info = (RegistryInfo)object;
        Element element = parent.getOwnerDocument().createElement(TAG_NAME);
        AbstractHandler handler = null;
        Properties props = info.getProperties();
        if (props != null && props.size() > 0) {
            handler = this.maker.lookup("property");
            TreeSet<Object> sortedProps = new TreeSet<Object>(props.keySet());
            Iterator keys = sortedProps.iterator();
            while (keys.hasNext()) {
                String name = (String)keys.next();
                String value = props.getProperty(name);
                handler.marshal(new Property(name, value), element);
            }
        }
        parent.appendChild(element);
    }

    public static void main(String[] args) throws Exception {
        HandlerMaker maker = HandlerMaker.getInstance();
        AbstractHandler handler = maker.lookup(TAG_NAME);
        Element parent = XMLUtils.newRootElement();
        Element child = null;
        RegistryInfo regInfo = new RegistryInfo();
        regInfo.addProperty(new Property("first_name", "Steve"));
        regInfo.addProperty(new Property("last_name", "Viens"));
        regInfo.addProperty(new Property("version", "1.0b1"));
        System.out.println();
        RegistryObject regObject = regInfo;
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
        System.out.println();
        regObject = handler.unmarshal(child);
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
    }
}

