/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.handler;

import java.util.Vector;
import org.apache.juddi.datatype.Description;
import org.apache.juddi.datatype.OverviewDoc;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.binding.AccessPoint;
import org.apache.juddi.datatype.binding.BindingTemplate;
import org.apache.juddi.datatype.binding.HostingRedirector;
import org.apache.juddi.datatype.binding.InstanceDetails;
import org.apache.juddi.datatype.binding.TModelInstanceDetails;
import org.apache.juddi.datatype.binding.TModelInstanceInfo;
import org.apache.juddi.datatype.request.AuthInfo;
import org.apache.juddi.datatype.request.SaveBinding;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.apache.juddi.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class SaveBindingHandler
extends AbstractHandler {
    public static final String TAG_NAME = "save_binding";
    private HandlerMaker maker = null;

    protected SaveBindingHandler(HandlerMaker maker) {
        this.maker = maker;
    }

    public RegistryObject unmarshal(Element element) {
        SaveBinding obj = new SaveBinding();
        Vector nodeList = null;
        AbstractHandler handler = null;
        String generic = element.getAttribute("generic");
        if (generic != null && generic.trim().length() > 0) {
            obj.setGeneric(generic);
        }
        if ((nodeList = XMLUtils.getChildElementsByTagName(element, "authInfo")).size() > 0) {
            handler = this.maker.lookup("authInfo");
            obj.setAuthInfo((AuthInfo)handler.unmarshal((Element)nodeList.elementAt(0)));
        }
        nodeList = XMLUtils.getChildElementsByTagName(element, "bindingTemplate");
        for (int i = 0; i < nodeList.size(); ++i) {
            handler = this.maker.lookup("bindingTemplate");
            obj.addBindingTemplate((BindingTemplate)handler.unmarshal((Element)nodeList.elementAt(i)));
        }
        return obj;
    }

    public void marshal(RegistryObject object, Element parent) {
        Vector bindingVector;
        AuthInfo authInfo;
        SaveBinding request = (SaveBinding)object;
        Element element = parent.getOwnerDocument().createElement(TAG_NAME);
        AbstractHandler handler = null;
        String generic = request.getGeneric();
        if (generic != null) {
            element.setAttribute("generic", generic);
        }
        if ((authInfo = request.getAuthInfo()) != null) {
            handler = this.maker.lookup("authInfo");
            handler.marshal(authInfo, element);
        }
        if ((bindingVector = request.getBindingTemplateVector()) != null && bindingVector.size() > 0) {
            handler = this.maker.lookup("bindingTemplate");
            for (int i = 0; i < bindingVector.size(); ++i) {
                handler.marshal((BindingTemplate)bindingVector.elementAt(i), element);
            }
        }
        parent.appendChild(element);
    }

    public static void main(String[] args) throws Exception {
        HandlerMaker maker = HandlerMaker.getInstance();
        AbstractHandler handler = maker.lookup(TAG_NAME);
        Element parent = XMLUtils.newRootElement();
        Element child = null;
        AuthInfo authInfo = new AuthInfo();
        authInfo.setValue("6f157513-844e-4a95-a856-d257e6ba9726");
        OverviewDoc overDoc = new OverviewDoc();
        overDoc.setOverviewURL("http://www.sviens.com/service.html");
        overDoc.addDescription(new Description("over-doc Descr"));
        overDoc.addDescription(new Description("over-doc Descr Two", "en"));
        InstanceDetails instDetails = new InstanceDetails();
        instDetails.addDescription(new Description("body-isa-wunder"));
        instDetails.addDescription(new Description("sweetchild-o-mine", "it"));
        instDetails.setInstanceParms("inst-det parameters");
        instDetails.setOverviewDoc(overDoc);
        TModelInstanceInfo tModInstInfo = new TModelInstanceInfo();
        tModInstInfo.setTModelKey("uuid:ae0f9fd4-287f-40c9-be91-df47a7c72fd9");
        tModInstInfo.addDescription(new Description("tMod-Inst-Info"));
        tModInstInfo.addDescription(new Description("tMod-Inst-Info too", "es"));
        tModInstInfo.setInstanceDetails(instDetails);
        TModelInstanceDetails tModInstDet = new TModelInstanceDetails();
        tModInstDet.addTModelInstanceInfo(tModInstInfo);
        BindingTemplate binding = new BindingTemplate();
        binding.setBindingKey("c9613c3c-fe55-4f34-a3da-b3167afbca4a");
        binding.setServiceKey("997a55bc-563d-4c04-8a94-781604870d31");
        binding.addDescription(new Description("whatever"));
        binding.addDescription(new Description("whatever too", "fr"));
        binding.setHostingRedirector(new HostingRedirector("92658289-0bd7-443c-8948-0bb4460b44c0"));
        binding.setAccessPoint(new AccessPoint("http", "http://www.sviens.com/service.wsdl"));
        binding.setTModelInstanceDetails(tModInstDet);
        SaveBinding service = new SaveBinding();
        service.setAuthInfo(authInfo);
        service.addBindingTemplate(binding);
        service.addBindingTemplate(binding);
        System.out.println();
        RegistryObject regObject = service;
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
        System.out.println();
        regObject = handler.unmarshal(child);
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
        System.out.println();
    }
}

