/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.handler;

import java.util.Vector;
import org.apache.juddi.datatype.Name;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.response.ServiceInfo;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.apache.juddi.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class ServiceInfoHandler
extends AbstractHandler {
    public static final String TAG_NAME = "serviceInfo";
    private HandlerMaker maker = null;

    protected ServiceInfoHandler(HandlerMaker maker) {
        this.maker = maker;
    }

    public RegistryObject unmarshal(Element element) {
        ServiceInfo obj = new ServiceInfo();
        Vector nodeList = null;
        AbstractHandler handler = null;
        obj.setServiceKey(element.getAttribute("serviceKey"));
        obj.setBusinessKey(element.getAttribute("businessKey"));
        nodeList = XMLUtils.getChildElementsByTagName(element, "name");
        for (int i = 0; i < nodeList.size(); ++i) {
            handler = this.maker.lookup("name");
            obj.addName((Name)handler.unmarshal((Element)nodeList.elementAt(i)));
        }
        return obj;
    }

    public void marshal(RegistryObject object, Element parent) {
        ServiceInfo info = (ServiceInfo)object;
        Element element = parent.getOwnerDocument().createElement(TAG_NAME);
        AbstractHandler handler = null;
        String serviceKey = info.getServiceKey();
        element.setAttribute("serviceKey", serviceKey != null ? serviceKey : "");
        String businessKey = info.getBusinessKey();
        element.setAttribute("businessKey", businessKey != null ? businessKey : "");
        Vector vector = info.getNameVector();
        if (vector != null && vector.size() > 0) {
            handler = this.maker.lookup("name");
            for (int i = 0; i < vector.size(); ++i) {
                handler.marshal((Name)vector.elementAt(i), element);
            }
        }
        parent.appendChild(element);
    }

    public static void main(String[] args) throws Exception {
    }
}

