/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.handler;

import java.util.Vector;
import org.apache.juddi.datatype.CategoryBag;
import org.apache.juddi.datatype.Description;
import org.apache.juddi.datatype.IdentifierBag;
import org.apache.juddi.datatype.KeyedReference;
import org.apache.juddi.datatype.OverviewDoc;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.response.TModelDetail;
import org.apache.juddi.datatype.tmodel.TModel;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.apache.juddi.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class TModelDetailHandler
extends AbstractHandler {
    public static final String TAG_NAME = "tModelDetail";
    private HandlerMaker maker = null;

    protected TModelDetailHandler(HandlerMaker maker) {
        this.maker = maker;
    }

    public RegistryObject unmarshal(Element element) {
        TModelDetail obj = new TModelDetail();
        Vector nodeList = null;
        AbstractHandler handler = null;
        obj.setGeneric(element.getAttribute("generic"));
        obj.setOperator(element.getAttribute("operator"));
        String truncValue = element.getAttribute("truncated");
        if (truncValue != null) {
            obj.setTruncated(truncValue.equalsIgnoreCase("true"));
        }
        nodeList = XMLUtils.getChildElementsByTagName(element, "tModel");
        for (int i = 0; i < nodeList.size(); ++i) {
            handler = this.maker.lookup("tModel");
            obj.addTModel((TModel)handler.unmarshal((Element)nodeList.elementAt(i)));
        }
        return obj;
    }

    public void marshal(RegistryObject object, Element parent) {
        Vector vector;
        boolean truncated;
        String operator;
        TModelDetail detail = (TModelDetail)object;
        Element element = parent.getOwnerDocument().createElement(TAG_NAME);
        AbstractHandler handler = null;
        String generic = detail.getGeneric();
        if (generic != null) {
            element.setAttribute("generic", generic);
            if (generic.equals("1.0")) {
                element.setAttribute("xmlns", "urn:uddi-org:api");
            } else if (generic.equals("2.0")) {
                element.setAttribute("xmlns", "urn:uddi-org:api_v2");
            } else if (generic.equals("3.0")) {
                element.setAttribute("xmlns", "urn:uddi-org:api_v3");
            }
        }
        if ((operator = detail.getOperator()) != null) {
            element.setAttribute("operator", operator);
        }
        if (truncated = detail.isTruncated()) {
            element.setAttribute("truncated", "true");
        }
        if ((vector = detail.getTModelVector()) != null && vector.size() > 0) {
            handler = this.maker.lookup("tModel");
            for (int i = 0; i < vector.size(); ++i) {
                handler.marshal((TModel)vector.elementAt(i), element);
            }
        }
        parent.appendChild(element);
    }

    public static void main(String[] args) throws Exception {
        HandlerMaker maker = HandlerMaker.getInstance();
        AbstractHandler handler = maker.lookup(TAG_NAME);
        Element parent = XMLUtils.newRootElement();
        Element child = null;
        OverviewDoc overDoc = new OverviewDoc();
        overDoc.setOverviewURL("http://www.sviens.com/service.html");
        overDoc.addDescription(new Description("over-doc Descr"));
        overDoc.addDescription(new Description("over-doc Descr Two", "en"));
        CategoryBag catBag = new CategoryBag();
        catBag.addKeyedReference(new KeyedReference("catBagKeyName", "catBagKeyValue"));
        catBag.addKeyedReference(new KeyedReference("uuid:dfddb58c-4853-4a71-865c-f84509017cc7", "catBagKeyName2", "catBagKeyValue2"));
        IdentifierBag idBag = new IdentifierBag();
        idBag.addKeyedReference(new KeyedReference("idBagKeyName", "idBagkeyValue"));
        idBag.addKeyedReference(new KeyedReference("uuid:f78a135a-4769-4e79-8604-54d440314bc0", "idBagKeyName2", "idBagkeyValue2"));
        TModel tModel = new TModel();
        tModel.setTModelKey("uuid:269855db-62eb-4862-8e5a-1b06f2753038");
        tModel.setOperator("jUDDI");
        tModel.setAuthorizedName("Steve Viens");
        tModel.setName("jUDDI TModel");
        tModel.addDescription(new Description("tModel whatever"));
        tModel.addDescription(new Description("tModel whatever too", "fr"));
        tModel.setCategoryBag(catBag);
        tModel.setIdentifierBag(idBag);
        tModel.setOverviewDoc(overDoc);
        TModelDetail detail = new TModelDetail();
        detail.setGeneric("2.0");
        detail.setOperator("jUDDI.org");
        detail.setTruncated(true);
        detail.addTModel(tModel);
        detail.addTModel(tModel);
        System.out.println();
        RegistryObject regObject = detail;
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
        System.out.println();
        regObject = handler.unmarshal(child);
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
    }
}

