/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.handler;

import java.util.Vector;
import org.apache.juddi.datatype.Description;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.binding.InstanceDetails;
import org.apache.juddi.datatype.binding.TModelInstanceInfo;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.apache.juddi.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class TModelInstanceInfoHandler
extends AbstractHandler {
    public static final String TAG_NAME = "tModelInstanceInfo";
    private HandlerMaker maker = null;

    protected TModelInstanceInfoHandler(HandlerMaker maker) {
        this.maker = maker;
    }

    public RegistryObject unmarshal(Element element) {
        int i;
        TModelInstanceInfo obj = new TModelInstanceInfo();
        Vector nodeList = null;
        AbstractHandler handler = null;
        obj.setTModelKey(element.getAttribute("tModelKey"));
        nodeList = XMLUtils.getChildElementsByTagName(element, "description");
        for (i = 0; i < nodeList.size(); ++i) {
            handler = this.maker.lookup("description");
            obj.addDescription((Description)handler.unmarshal((Element)nodeList.elementAt(i)));
        }
        nodeList = XMLUtils.getChildElementsByTagName(element, "instanceDetails");
        for (i = 0; i < nodeList.size(); ++i) {
            handler = this.maker.lookup("instanceDetails");
            obj.setInstanceDetails((InstanceDetails)handler.unmarshal((Element)nodeList.elementAt(i)));
        }
        return obj;
    }

    public void marshal(RegistryObject object, Element parent) {
        InstanceDetails instDet;
        Vector descrVector;
        TModelInstanceInfo tModInstInfo = (TModelInstanceInfo)object;
        Element element = parent.getOwnerDocument().createElement(TAG_NAME);
        AbstractHandler handler = null;
        String tModelKey = tModInstInfo.getTModelKey();
        if (tModelKey != null) {
            element.setAttribute("tModelKey", tModelKey);
        }
        if ((descrVector = tModInstInfo.getDescriptionVector()) != null && descrVector.size() > 0) {
            handler = this.maker.lookup("description");
            for (int i = 0; i < descrVector.size(); ++i) {
                handler.marshal((Description)descrVector.elementAt(i), element);
            }
        }
        if ((instDet = tModInstInfo.getInstanceDetails()) != null) {
            handler = this.maker.lookup("instanceDetails");
            handler.marshal(instDet, element);
        }
        parent.appendChild(element);
    }

    public static void main(String[] args) throws Exception {
    }
}

