/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.monitor;

import org.apache.axis.MessageContext;
import org.apache.axis.transport.http.AxisServlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.request.AuthInfo;
import org.apache.juddi.datatype.request.DiscardAuthToken;
import org.apache.juddi.datatype.request.Publish;
import org.apache.juddi.monitor.Monitor;
import org.apache.juddi.monitor.MonitorData;
import org.w3c.dom.Element;

public abstract class MonitorAdapter
implements Monitor {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$juddi$monitor$MonitorAdapter == null ? (class$org$apache$juddi$monitor$MonitorAdapter = MonitorAdapter.class$("org.apache.juddi.monitor.MonitorAdapter")) : class$org$apache$juddi$monitor$MonitorAdapter));
    protected MonitorData data = null;
    static /* synthetic */ Class class$org$apache$juddi$monitor$MonitorAdapter;

    public MonitorAdapter() {
        this.init();
    }

    protected void init() {
        this.data = new MonitorData();
    }

    public void inspectMessageContext(MessageContext messageContext) {
        String remoteHost = messageContext.getProperty("remoteaddr").toString();
        String requestedURI = messageContext.getProperty("path").toString();
        log.debug((Object)("RequestedURI: " + requestedURI + ",RemoteHost: " + remoteHost));
        this.data.setRequestURI(requestedURI);
        this.data.setRemoteHost(remoteHost);
        AxisServlet axisServlet = (AxisServlet)messageContext.getProperty("transport.http.servlet");
    }

    public void inspectUDDIRequest(Element request) {
        if (request != null) {
            this.data.setCalledFunction(request.getLocalName());
            String generic = request.getAttribute("generic");
            if (generic == null) {
                generic = "2.0";
            }
            this.data.setUddiVersion(generic);
        }
    }

    public void inspectRegistryObject(RegistryObject registryObject) {
        AuthInfo authInfo = null;
        if (registryObject instanceof Publish) {
            authInfo = ((Publish)((Object)registryObject)).getAuthInfo();
        } else if (registryObject instanceof DiscardAuthToken) {
            authInfo = ((DiscardAuthToken)registryObject).getAuthInfo();
        }
        if (authInfo != null) {
            this.data.setAuthToken(authInfo.getValue());
        }
    }

    public void addMonitorFault(String faultString) {
        String fault = this.data.getFault();
        if (fault != "") {
            faultString = "; " + faultString;
        }
        this.data.setFault(fault + faultString);
    }

    public abstract void log();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

