/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.monitor.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.monitor.MonitorData;
import org.apache.juddi.util.Config;
import org.apache.juddi.util.jdbc.ConnectionManager;
import org.apache.juddi.util.jdbc.Transaction;
import org.apache.juddi.uuidgen.UUIDGen;
import org.apache.juddi.uuidgen.UUIDGenFactory;

class MonitorTable {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$juddi$monitor$jdbc$MonitorTable == null ? (class$org$apache$juddi$monitor$jdbc$MonitorTable = MonitorTable.class$("org.apache.juddi.monitor.jdbc.MonitorTable")) : class$org$apache$juddi$monitor$jdbc$MonitorTable));
    static String insertSQL = null;
    static String selectSQL = null;
    static String deleteSQL = null;
    static /* synthetic */ Class class$org$apache$juddi$monitor$jdbc$MonitorTable;

    MonitorTable() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insert(MonitorData data, Connection connection) throws SQLException {
        if (data == null) {
            return;
        }
        PreparedStatement statement = null;
        Timestamp timeStamp = new Timestamp(System.currentTimeMillis());
        try {
            statement = connection.prepareStatement(insertSQL);
            statement.setString(1, data.getRemoteHost());
            statement.setString(2, data.getRequestURI());
            statement.setString(3, data.getCalledFunction());
            statement.setString(4, data.getAuthToken());
            statement.setString(5, data.getVersion());
            statement.setTimestamp(6, timeStamp);
            statement.setString(7, data.getFault());
            log.debug((Object)("insert into MONITOR table:\n\n\t" + insertSQL + "\n\t REMOTE_HOST=" + data.getRemoteHost() + "\n\t REQUEST_URI=" + data.getRequestURI() + "\n\t CALLED_FUNCTION=" + data.getCalledFunction() + "\n\t AUTH_TOKEN=" + data.getAuthToken() + "\n\t UDDI_VERSION=" + data.getVersion() + "\n\t LOG_TIME=" + timeStamp.getTime() + "\n\t FAULT=" + data.getFault() + "\n"));
            statement.executeUpdate();
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Config.setStringProperty("juddi.useConnectionPool", "true");
        Connection conn = null;
        try {
            conn = ConnectionManager.aquireConnection();
            MonitorTable.test(conn);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    public static void test(Connection connection) throws Exception {
        UUIDGen uuidgen = UUIDGenFactory.getUUIDGen();
        Transaction txn = new Transaction();
        if (connection != null) {
            try {
                MonitorData data = new MonitorData("123.234.345.456", "testFunction");
                data.setAuthToken("");
                data.setUddiVersion("2.0");
                data.setFault("None");
                txn.begin(connection);
                MonitorTable.insert(data, connection);
                txn.commit();
            }
            catch (Exception ex) {
                try {
                    txn.rollback();
                }
                catch (SQLException sqlex) {
                    sqlex.printStackTrace();
                }
                throw ex;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        StringBuffer sql = null;
        sql = new StringBuffer(150);
        sql.append("INSERT INTO MONITOR (");
        sql.append("REMOTE_HOST,");
        sql.append("REQUEST_URI,");
        sql.append("CALLED_FUNCTION,");
        sql.append("AUTH_TOKEN,");
        sql.append("UDDI_VERSION,");
        sql.append("LOG_TIME,");
        sql.append("FAULT) ");
        sql.append("VALUES (?,?,?,?,?,?,?)");
        insertSQL = sql.toString();
        sql = new StringBuffer(200);
        sql.append("SELECT ");
        sql.append("LOG_TIME,");
        sql.append("REMOTE_HOST,");
        sql.append("REQUEST_URI,");
        sql.append("CALLED_FUNCTION,");
        sql.append("AUTH_TOKEN,");
        sql.append("UDDI_VERSION,");
        sql.append("FAULT) ");
        sql.append("FROM MONITOR ");
        sql.append("WHERE FAULT=? ");
        selectSQL = sql.toString();
        sql = new StringBuffer(100);
        sql.append("DELETE FROM MONITOR ");
        sql.append("WHERE FAULT=? ");
        deleteSQL = sql.toString();
    }
}

