/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.registry;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.registry.RegistryEngine;

public class RegistryServlet
extends HttpServlet {
    private static final String CONFIG_FILE_PROPERTY_NAME = "juddi.propertiesFile";
    private static final String DEFAULT_PROPERTY_FILE = "/WEB-INF/juddi.properties";
    private static Log log = LogFactory.getLog((Class)(class$org$apache$juddi$registry$RegistryServlet == null ? (class$org$apache$juddi$registry$RegistryServlet = RegistryServlet.class$("org.apache.juddi.registry.RegistryServlet")) : class$org$apache$juddi$registry$RegistryServlet));
    private static RegistryEngine registry = null;
    static /* synthetic */ Class class$org$apache$juddi$registry$RegistryServlet;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        Properties props = new Properties();
        try {
            InputStream is;
            log.info((Object)"jUDDI Starting: Loading resources and initializing subsystems.");
            String propFile = config.getInitParameter(CONFIG_FILE_PROPERTY_NAME);
            if (propFile == null || propFile.trim().length() == 0) {
                propFile = DEFAULT_PROPERTY_FILE;
            }
            if ((is = this.getServletContext().getResourceAsStream(propFile)) != null) {
                log.info((Object)("Resources loaded from: " + propFile));
                props.load(is);
            } else {
                log.warn((Object)("Could not locate jUDDI properties '" + propFile + "'. Using defaults."));
                props.put("juddi.operatorName", "Apache.org");
                props.put("juddi.operatorURL", "http://localhost:8080/juddi/");
                props.put("juddi.adminEmailAddress", "nobody@apache.org");
                props.put("juddi.dataSource", "java:comp/env/jdbc/juddiDB");
                props.put("juddi.auth", "org.apache.juddi.auth.DefaultAuthenticator");
                props.put("juddi.cryptor", "org.apache.juddi.cryptor.DefaultCryptor");
                props.put("juddi.dataStore", "org.apache.juddi.datastore.JDBCDataStore");
                props.put("juddi.monitor", "org.apache.juddi.monitor.jdbc.JDBCMonitor");
                props.put("juddi.uuidgen", "org.apache.juddi.uuidgen.DefaultUUIDGen");
                props.put("juddi.validator", "org.apache.juddi.validator.DefaultValidator");
                props.put("juddi.maxNameElementsAllowed", Integer.toString(5));
                props.put("juddi.maxNameLengthAllowed", Integer.toString(255));
                props.put("juddi.maxMessageSize", Integer.toString(0x200000));
                props.put("juddi.maxBusinessEntitiesPerUser", Integer.toString(25));
                props.put("juddi.maxBusinessServicesPerBusiness", Integer.toString(20));
                props.put("juddi.maxBindingTemplatesPerService", Integer.toString(10));
                props.put("juddi.maxTModelsPerUser", Integer.toString(100));
                props.put("juddi.maxRowsLimit", Integer.toString(10));
            }
        }
        catch (IOException ioex) {
            log.error((Object)ioex.getMessage(), (Throwable)ioex);
        }
        log.info((Object)"Initializing jUDDI subsystems.");
        registry = new RegistryEngine(props);
        registry.init();
    }

    public void destroy() {
        super.destroy();
        log.info((Object)"jUDDI Stopping: Cleaning up existing resources.");
        RegistryEngine registry = RegistryServlet.getRegistry();
        if (registry != null) {
            registry.dispose();
        }
    }

    public static RegistryEngine getRegistry() {
        return registry;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

