/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.util.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.juddi.util.Config;
import org.apache.juddi.util.Loader;

public class ConnectionManager {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$juddi$util$jdbc$ConnectionManager == null ? (class$org$apache$juddi$util$jdbc$ConnectionManager = ConnectionManager.class$("org.apache.juddi.util.jdbc.ConnectionManager")) : class$org$apache$juddi$util$jdbc$ConnectionManager));
    private static final String USE_CONNECTION_POOL_VALUE_KEY = "juddi.useConnectionPool";
    private static final boolean DEFAULT_USE_CONNECTION_POOL_VALUE = false;
    private static final String JDBC_DRIVER_KEY = "juddi.jdbcDriver";
    private static final String DEFAULT_JDBC_DRIVER = "com.mysql.jdbc.Driver";
    private static final String JDBC_URL_KEY = "juddi.jdbcURL";
    private static final String DEFAULT_JDBC_URL = "jdbc:mysql://localhost/juddi";
    private static final String JDBC_USERNAME_KEY = "juddi.jdbcUser";
    private static final String DEFAULT_JDBC_USERNAME = "juddi";
    private static final String JDBC_PASSWORD_KEY = "juddi.jdbcPassword";
    private static final String DEFAULT_JDBC_PASSWORD = "juddi";
    private static final String JDBC_MAX_ACTIVITY_KEY = "juddi.maxActive";
    private static final int DEFAULT_JDBC_MAX_ACTIVITY = 10;
    private static final String JDBC_MAX_IDLE_KEY = "juddi.maxIdle";
    private static final int DEFAULT_JDBC_MAX_IDLE = 5;
    private static DataSource dataSource = null;
    static /* synthetic */ Class class$org$apache$juddi$util$jdbc$ConnectionManager;

    public static Connection aquireConnection() throws SQLException {
        if (dataSource == null) {
            dataSource = ConnectionManager.getDataSource();
        }
        Connection conn = null;
        if (dataSource != null) {
            conn = dataSource.getConnection();
        }
        return conn;
    }

    private static synchronized DataSource getDataSource() throws SQLException {
        if (dataSource != null) {
            return dataSource;
        }
        boolean useInternalConnectionPool = Config.getBooleanProperty(USE_CONNECTION_POOL_VALUE_KEY, false);
        if (useInternalConnectionPool) {
            if (dataSource == null) {
                dataSource = ConnectionManager.createDataSource();
            }
        } else if (dataSource == null) {
            dataSource = ConnectionManager.lookupDataSource();
        }
        return dataSource;
    }

    private static DataSource createDataSource() throws SQLException {
        if (dataSource != null) {
            return dataSource;
        }
        String dbcpDriver = Config.getStringProperty(JDBC_DRIVER_KEY, DEFAULT_JDBC_DRIVER);
        String dbcpURL = Config.getStringProperty(JDBC_URL_KEY, DEFAULT_JDBC_URL);
        String dbcpUser = Config.getStringProperty(JDBC_USERNAME_KEY, "juddi");
        String dbcpPassword = Config.getStringProperty(JDBC_PASSWORD_KEY, "juddi");
        int dbcpMaxActive = Config.getIntProperty(JDBC_MAX_ACTIVITY_KEY, 10);
        int dbcpMaxIdle = Config.getIntProperty(JDBC_MAX_IDLE_KEY, 5);
        log.info((Object)("Using DBCP to create a JDBC DataSource using properties: \n\tDriver:    " + dbcpDriver + "\n" + "\tURL:       " + dbcpURL + "\n" + "\tUser:      " + dbcpUser + "\n" + "\tPassword:  " + dbcpPassword + "\n" + "\tMaxActive: " + dbcpMaxActive + "\n" + "\tMaxIdle:   " + dbcpMaxIdle + "\n"));
        try {
            Loader.getClassForName(dbcpDriver);
        }
        catch (ClassNotFoundException cnfex) {
            throw new SQLException("Could not locate JDBC Driver '" + dbcpDriver + "' in classpath: " + cnfex.getMessage());
        }
        GenericObjectPool connPool = new GenericObjectPool(null);
        connPool.setMaxActive(10);
        connPool.setMaxIdle(10);
        DriverManagerConnectionFactory connFact = new DriverManagerConnectionFactory(dbcpURL, dbcpUser, dbcpPassword);
        try {
            PoolableConnectionFactory pcf = new PoolableConnectionFactory((ConnectionFactory)connFact, (ObjectPool)connPool, null, null, false, true);
        }
        catch (Exception ex) {
            throw new SQLException(ex.getMessage());
        }
        PoolingDataSource dataSource = new PoolingDataSource((ObjectPool)connPool);
        return dataSource;
    }

    private static DataSource lookupDataSource() throws SQLException {
        if (dataSource != null) {
            return dataSource;
        }
        try {
            String dataSourceName = Config.getStringProperty("juddi.dataSource", "java:comp/env/jdbc/juddiDB");
            log.info((Object)("Using JNDI to aquire a JDBC DataSource with name: " + dataSourceName));
            InitialContext initCtx = new InitialContext();
            dataSource = (DataSource)initCtx.lookup(dataSourceName);
        }
        catch (NamingException nex) {
            log.error((Object)("Exception occurred while attempting to acquire a JDBC DataSource from JNDI: " + nex.getMessage()));
        }
        return dataSource;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

