/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.util.xml;

import java.io.OutputStream;
import java.io.Writer;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLUtils {
    private static DocumentBuilder docBuilder = null;

    public static String getText(Element element) {
        StringBuffer textBuffer = new StringBuffer();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() != 3) continue;
            textBuffer.append(nodeList.item(i).getNodeValue());
        }
        return textBuffer.toString().trim();
    }

    public static Vector getChildElementsByTagName(Element element, String tagName) {
        Vector<Node> result = new Vector<Node>();
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (node.getNodeType() != 1 || !node.getLocalName().equals(tagName)) continue;
            result.addElement(node);
        }
        return result;
    }

    public static Element newRootElement() {
        Element element = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element holder = document.createElement("root");
            document.appendChild(holder);
            element = document.getDocumentElement();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return element;
    }

    public static Document createDocument() {
        if (docBuilder == null) {
            docBuilder = XMLUtils.createDocumentBuilder();
        }
        return docBuilder.newDocument();
    }

    private static DocumentBuilder createDocumentBuilder() {
        if (docBuilder != null) {
            return docBuilder;
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            docBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException pcex) {
            pcex.printStackTrace();
        }
        return docBuilder;
    }

    public static void writeXML(Element element, OutputStream stream) {
        org.apache.axis.utils.XMLUtils.ElementToStream((Element)element, (OutputStream)stream);
    }

    public static void writeXML(Element element, Writer writer) {
        org.apache.axis.utils.XMLUtils.ElementToWriter((Element)element, (Writer)writer);
    }
}

