/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import java.util.Locale;
import java.util.Map;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.IAbstractSyntaxTreeVisitor;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.ISourceType;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.parser.SourceTypeConverter;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.core.BasicCompilationUnit;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.SearchableEnvironment;

class CompilationUnitResolver
extends Compiler {
    public CompilationUnitResolver(INameEnvironment environment, IErrorHandlingPolicy policy, Map settings, ICompilerRequestor requestor, IProblemFactory problemFactory) {
        super(environment, policy, settings, requestor, problemFactory, false);
    }

    public void accept(ISourceType[] sourceTypes, PackageBinding packageBinding) {
        CompilationResult result = new CompilationResult(sourceTypes[0].getFileName(), 1, 1, this.options.maxProblemsPerUnit);
        CompilationUnitDeclaration unit = SourceTypeConverter.buildCompilationUnit(sourceTypes, true, true, false, this.lookupEnvironment.problemReporter, result);
        if (unit != null) {
            this.lookupEnvironment.buildTypeBindings(unit);
            this.lookupEnvironment.completeTypeBindings(unit, true);
        }
    }

    protected static IErrorHandlingPolicy getHandlingPolicy() {
        return new IErrorHandlingPolicy(){

            public boolean stopOnFirstError() {
                return false;
            }

            public boolean proceedOnErrors() {
                return false;
            }
        };
    }

    protected static INameEnvironment getNameEnvironment(ICompilationUnit sourceUnit) throws JavaModelException {
        return (SearchableEnvironment)((JavaProject)sourceUnit.getJavaProject()).getSearchableNameEnvironment();
    }

    protected static INameEnvironment getNameEnvironment(IJavaProject javaProject) throws JavaModelException {
        return (SearchableEnvironment)((JavaProject)javaProject).getSearchableNameEnvironment();
    }

    protected static ICompilerRequestor getRequestor() {
        return new ICompilerRequestor(){

            public void acceptResult(CompilationResult compilationResult) {
            }
        };
    }

    public static CompilationUnitDeclaration resolve(ICompilationUnit unitElement, IAbstractSyntaxTreeVisitor visitor) throws JavaModelException {
        char[] fileName = unitElement.getElementName().toCharArray();
        IJavaProject project = unitElement.getJavaProject();
        CompilationUnitResolver compilationUnitVisitor = new CompilationUnitResolver(CompilationUnitResolver.getNameEnvironment(unitElement), CompilationUnitResolver.getHandlingPolicy(), project.getOptions(true), CompilationUnitResolver.getRequestor(), CompilationUnitResolver.getProblemFactory(fileName, visitor));
        CompilationUnitDeclaration unit = null;
        try {
            String encoding = project.getOption("org.eclipse.jdt.core.encoding", true);
            IPackageFragment packageFragment = (IPackageFragment)unitElement.getAncestor(4);
            char[][] expectedPackageName = null;
            if (packageFragment != null) {
                expectedPackageName = CharOperation.splitOn('.', packageFragment.getElementName().toCharArray());
            }
            CompilationUnitDeclaration compilationUnitDeclaration = unit = compilationUnitVisitor.resolve(new BasicCompilationUnit(unitElement.getSource().toCharArray(), expectedPackageName, new String(fileName), encoding), true, true, true);
            Object var9_10 = null;
            if (unit != null) {
                unit.cleanUp();
            }
            return compilationUnitDeclaration;
        }
        catch (Throwable throwable) {
            block4: {
                Object var9_11 = null;
                if (unit == null) break block4;
                unit.cleanUp();
            }
            throw throwable;
        }
    }

    public static CompilationUnitDeclaration parse(char[] source, Map settings) {
        if (source == null) {
            throw new IllegalArgumentException();
        }
        CompilerOptions compilerOptions = new CompilerOptions(settings);
        Parser parser = new Parser(new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), compilerOptions, new DefaultProblemFactory(Locale.getDefault())), false, compilerOptions.sourceLevel);
        CompilationUnit sourceUnit = new CompilationUnit(source, "", compilerOptions.defaultEncoding);
        CompilationUnitDeclaration compilationUnitDeclaration = parser.dietParse(sourceUnit, new CompilationResult(sourceUnit, 0, 0, compilerOptions.maxProblemsPerUnit));
        if (compilationUnitDeclaration.ignoreMethodBodies) {
            compilationUnitDeclaration.ignoreFurtherInvestigation = true;
            return compilationUnitDeclaration;
        }
        parser.scanner.setSource(source);
        TypeDeclaration[] types = compilationUnitDeclaration.types;
        if (types != null) {
            int i = types.length;
            while (--i >= 0) {
                types[i].parseMethod(parser, compilationUnitDeclaration);
            }
        }
        return compilationUnitDeclaration;
    }

    protected static IProblemFactory getProblemFactory(final char[] fileName, final IAbstractSyntaxTreeVisitor visitor) {
        return new DefaultProblemFactory(Locale.getDefault()){

            public IProblem createProblem(char[] originatingFileName, int problemId, String[] problemArguments, String[] messageArguments, int severity, int startPosition, int endPosition, int lineNumber) {
                IProblem problem = super.createProblem(originatingFileName, problemId, problemArguments, messageArguments, severity, startPosition, endPosition, lineNumber);
                if (CharOperation.equals(originatingFileName, fileName)) {
                    visitor.acceptProblem(problem);
                }
                return problem;
            }
        };
    }

    public static CompilationUnitDeclaration resolve(char[] source, String unitName, IJavaProject javaProject, IAbstractSyntaxTreeVisitor visitor) throws JavaModelException {
        CompilationUnitResolver compilationUnitVisitor = new CompilationUnitResolver(CompilationUnitResolver.getNameEnvironment(javaProject), CompilationUnitResolver.getHandlingPolicy(), javaProject.getOptions(true), CompilationUnitResolver.getRequestor(), CompilationUnitResolver.getProblemFactory(unitName.toCharArray(), visitor));
        CompilationUnitDeclaration unit = null;
        try {
            String encoding = javaProject.getOption("org.eclipse.jdt.core.encoding", true);
            CompilationUnitDeclaration compilationUnitDeclaration = unit = compilationUnitVisitor.resolve(new BasicCompilationUnit(source, null, unitName, encoding), true, true, true);
            Object var7_8 = null;
            if (unit != null) {
                unit.cleanUp();
            }
            return compilationUnitDeclaration;
        }
        catch (Throwable throwable) {
            block3: {
                Object var7_9 = null;
                if (unit == null) break block3;
                unit.cleanUp();
            }
            throw throwable;
        }
    }

    public static CompilationUnitDeclaration resolve(char[] source, char[][] packageName, String unitName, IJavaProject javaProject, IAbstractSyntaxTreeVisitor visitor) throws JavaModelException {
        CompilationUnitResolver compilationUnitVisitor = new CompilationUnitResolver(CompilationUnitResolver.getNameEnvironment(javaProject), CompilationUnitResolver.getHandlingPolicy(), javaProject.getOptions(true), CompilationUnitResolver.getRequestor(), CompilationUnitResolver.getProblemFactory(unitName.toCharArray(), visitor));
        CompilationUnitDeclaration unit = null;
        try {
            String encoding = javaProject.getOption("org.eclipse.jdt.core.encoding", true);
            CompilationUnitDeclaration compilationUnitDeclaration = unit = compilationUnitVisitor.resolve(new BasicCompilationUnit(source, packageName, unitName, encoding), true, true, true);
            Object var8_9 = null;
            if (unit != null) {
                unit.cleanUp();
            }
            return compilationUnitDeclaration;
        }
        catch (Throwable throwable) {
            block3: {
                Object var8_10 = null;
                if (unit == null) break block3;
                unit.cleanUp();
            }
            throw throwable;
        }
    }
}

