/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.SimpleName;

public class FieldAccess
extends Expression {
    private Expression expression = null;
    private SimpleName fieldName = null;

    FieldAccess(AST ast) {
        super(ast);
    }

    public int getNodeType() {
        return 22;
    }

    ASTNode clone(AST target) {
        FieldAccess result = new FieldAccess(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.setExpression((Expression)this.getExpression().clone(target));
        result.setName((SimpleName)this.getName().clone(target));
        return result;
    }

    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.acceptChild(visitor, this.getExpression());
            this.acceptChild(visitor, this.getName());
        }
        visitor.endVisit(this);
    }

    public Expression getExpression() {
        if (this.expression == null) {
            long count = this.getAST().modificationCount();
            this.setExpression(new SimpleName(this.getAST()));
            this.getAST().setModificationCount(count);
        }
        return this.expression;
    }

    public void setExpression(Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException();
        }
        this.replaceChild(this.expression, expression, true);
        this.expression = expression;
    }

    public SimpleName getName() {
        if (this.fieldName == null) {
            long count = this.getAST().modificationCount();
            this.setName(new SimpleName(this.getAST()));
            this.getAST().setModificationCount(count);
        }
        return this.fieldName;
    }

    public void setName(SimpleName fieldName) {
        if (fieldName == null) {
            throw new IllegalArgumentException();
        }
        this.replaceChild(this.fieldName, fieldName, false);
        this.fieldName = fieldName;
    }

    int memSize() {
        return 44;
    }

    public IVariableBinding resolveFieldBinding() {
        return this.getAST().getBindingResolver().resolveField(this);
    }

    int treeSize() {
        return this.memSize() + (this.expression == null ? 0 : this.getExpression().treeSize()) + (this.fieldName == null ? 0 : this.getName().treeSize());
    }
}

